/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.connections.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorFolderNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.Messages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionDescriptorRepository {
    private IConnectionDescriptorNode m_root;
    private IConnectionDescriptorNode m_autoDiscoveryNode;

    public synchronized void storeSettings() {
        try {
            Document doc = XmlToolkit.createNewDocument((String)"browser_view");
            Element treeRoot = XmlToolkit.createElement((Element)doc.getDocumentElement(), (String)"tree");
            treeRoot = XmlToolkit.createElement((Element)treeRoot, (String)this.getBrowserModelRoot().getComponentTag());
            this.getUserNode().exportToXml(treeRoot);
            RJMXPlugin.getDefault().getPreferenceStore().setValue("tree", XmlToolkit.storeDocumentToString((Document)doc));
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Problem storing browser settings", e);
        }
    }

    public synchronized void loadSettings() {
        String doc = RJMXPlugin.getDefault().getPreferenceStore().getString("tree");
        try {
            if (doc != null && !"".equals(doc)) {
                this.m_root = new ConnectionDescriptorFolderNode(null, "Invisible Root");
                IConnectionDescriptorNode user = this.m_root.addFolder(Messages.BrowserModel_FOLDER_NAME_CONNECTOR);
                user.initializeFromXml(XmlToolkit.getOrCreateElement((Element)XmlToolkit.getOrCreateElement((Element)XmlToolkit.loadDocumentFromString((String)doc).getDocumentElement(), (String)"tree"), (String)this.m_root.getComponentTag()));
                this.m_autoDiscoveryNode = this.m_root.addFolder(Messages.BrowserModel_FOLDER_NAME_AUTO_LIST);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Problem initializing from browser settings", e);
        }
        this.diffAgainstConsoleModel();
    }

    public IConnectionDescriptorNode getAutoDetectNode() {
        return this.m_autoDiscoveryNode;
    }

    public IConnectionDescriptorNode getBrowserModelRoot() {
        if (this.m_root == null) {
            this.m_root = new ConnectionDescriptorFolderNode(null, "Invisible Root");
            this.m_root.addFolder(Messages.BrowserModel_FOLDER_NAME_CONNECTOR);
            this.m_autoDiscoveryNode = this.m_root.addFolder(Messages.BrowserModel_FOLDER_NAME_AUTO_LIST);
        }
        return this.m_root;
    }

    private void diffAgainstConsoleModel() {
        IConnectionDescriptor descriptor;
        HashMap<String, IConnectionDescriptor> map = new HashMap<String, IConnectionDescriptor>();
        Iterator iter = AbstractConnectionDescriptorNode.getConnectionDescriptors(this.getBrowserModelRoot()).iterator();
        while (iter.hasNext()) {
            descriptor = (IConnectionDescriptor)iter.next();
            map.put(descriptor.getGUID(), descriptor);
        }
        iter = RJMXPlugin.getDefault().getDescriptorRepository().getConnectionDescriptors().iterator();
        while (iter.hasNext()) {
            descriptor = (IConnectionDescriptor)iter.next();
            if (map.get(descriptor.getGUID()) != null) continue;
            RJMXPlugin.getDefault().getLogger().warning("Found discrepancy in Browser View - could not find " + descriptor.getName() + " in view. Removing it from the model...");
            iter.remove();
        }
    }

    public IConnectionDescriptorNode getDiscoveryNode() {
        return this.m_autoDiscoveryNode;
    }

    public IConnectionDescriptorNode getUserNode() {
        return this.getBrowserModelRoot().getChildAt(0);
    }
}

