/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.connections.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionHandler;
import com.jrockit.mc.rjmx.core.connections.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class ConnectionDescriptorNode
extends AbstractConnectionDescriptorNode {
    public static final String COMPONENT_TAG = "connector_node";
    private static final Map adapterToConnectionNode = new WeakHashMap();
    private List m_connectionHandlers = new ArrayList();
    private IConnectionDescriptor m_connectionProperties;
    static /* synthetic */ Class class$0;

    public ConnectionDescriptorNode(IConnectionDescriptorNode parent, IConnectionDescriptor connectionProperties) {
        this.m_parent = parent;
        this.m_connectionProperties = connectionProperties;
        RJMXPlugin.getDefault().getDescriptorRepository().add(this.m_connectionProperties);
    }

    public IConnectionDescriptorNode addConnectionDescriptor(IConnectionDescriptor props) {
        RJMXPlugin.getDefault().getDescriptorRepository().add(props);
        return this.m_parent.addConnectionDescriptor(props);
    }

    public IConnectionDescriptorNode addFolder(String folderName) {
        return this.m_parent.addFolder(folderName);
    }

    public String getName() {
        return this.getConnectionDescriptor().getName();
    }

    public void setName(String name) {
        this.m_connectionProperties = ConnectionDescriptorToolkit.rename((IConnectionDescriptor)this.getConnectionDescriptor(), (String)name);
    }

    public IConnectionDescriptorNode getChildAt(int i) {
        return null;
    }

    public boolean isConnectionNode() {
        return true;
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.m_connectionProperties;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public void removeChild(IConnectionDescriptorNode child) {
    }

    public void exportToXml(Element parentNode) {
        XmlToolkit.setSetting((Element)parentNode, (String)"uid", (String)this.m_connectionProperties.getGUID());
    }

    public String getComponentTag() {
        return COMPONENT_TAG;
    }

    public void initializeFromXml(Element node) throws Exception {
        String guid = XmlToolkit.getSetting((Element)node, (String)"uid", (String)"-1");
        this.m_connectionProperties = RJMXPlugin.getDefault().getDescriptorRepository().getConnectionDescriptorByGUID(guid);
        if (this.m_connectionProperties == null) {
            throw new Exception(NLS.bind((String)Messages.JRockitBrowserConnectionNode_EXCEPTION_MESSAGE_NO_CONNECTOR_WITH_ID, (Object)guid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Class adapterClass) {
        Object myAdapter = super.getAdapter(adapterClass);
        if (myAdapter == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (adapterToConnectionNode.get(myAdapter) != null) {
                Iterator entries = adapterToConnectionNode.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    Object key = entry.getKey();
                    if (!myAdapter.equals(key)) continue;
                    myAdapter = key;
                    break;
                }
            }
            adapterToConnectionNode.put(myAdapter, this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return myAdapter;
        }
    }

    public static synchronized ConnectionDescriptorNode getConnectionNodeFor(Object adapter) {
        return (ConnectionDescriptorNode)adapterToConnectionNode.get(adapter);
    }

    public synchronized void addConnectionHandler(IConnectionHandler handler) {
        this.m_connectionHandlers.add(handler);
        if (this.m_connectionHandlers.size() == 1) {
            this.updateTree();
        }
    }

    public synchronized void removeConnectionHandler(IConnectionHandler handler) {
        if (this.m_connectionHandlers.remove(handler) && this.getConnectionHandlers().size() == 0) {
            this.updateTree();
        }
    }

    public boolean isConnected() {
        if (this.m_connectionHandlers.isEmpty()) {
            return false;
        }
        Iterator iter = this.m_connectionHandlers.iterator();
        while (iter.hasNext()) {
            if (!((IConnectionHandler)iter.next()).isConnected()) continue;
            return true;
        }
        return false;
    }

    public List getConnectionHandlers() {
        return new ArrayList(this.m_connectionHandlers);
    }

    public void setConnectionDescriptor(IConnectionDescriptor connectorProperties) {
        this.m_connectionProperties = connectorProperties;
        RJMXPlugin.getDefault().getDescriptorRepository().add(this.m_connectionProperties);
        this.updateTree();
    }
}

