/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.connections.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectionDescriptorFolderNode
extends AbstractConnectionDescriptorNode {
    public static final String COMPONENT_TAG = "folder_node";
    private ArrayList m_children = new ArrayList();
    private String m_name;

    public ConnectionDescriptorFolderNode(IConnectionDescriptorNode parent, String name) {
        this.m_parent = parent;
        this.m_name = name;
    }

    public IConnectionDescriptorNode addConnectionDescriptor(IConnectionDescriptor cd) {
        ConnectionDescriptorNode node = new ConnectionDescriptorNode(this, cd);
        this.m_children.add(node);
        return node;
    }

    public IConnectionDescriptorNode addFolder(String folderName) {
        ConnectionDescriptorFolderNode node = new ConnectionDescriptorFolderNode(this, folderName);
        this.m_children.add(node);
        return node;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
        this.updateTree();
    }

    public IConnectionDescriptorNode getChildAt(int i) {
        return (IConnectionDescriptorNode)this.m_children.get(i);
    }

    public boolean isConnectionNode() {
        return false;
    }

    protected boolean isRootChild() {
        return this.getParent() != null && this.getParent().getParent() == null;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public boolean isLeaf() {
        return this.m_children.size() <= 0;
    }

    public String toString() {
        return this.getName();
    }

    public void removeChild(IConnectionDescriptorNode child) {
        int i = 0;
        while (i < child.getChildCount()) {
            child.removeChild(child.getChildAt(i));
            ++i;
        }
        if (child.isConnectionNode()) {
            RJMXPlugin.getDefault().getDescriptorRepository().remove(child.getConnectionDescriptor());
        }
        this.m_children.remove(child);
    }

    public void exportToXml(Element parentNode) {
        XmlToolkit.setSetting((Element)parentNode, (String)"folder_name", (String)this.getName());
        int i = 0;
        while (i < this.getChildCount()) {
            IConnectionDescriptorNode child = (IConnectionDescriptorNode)this.m_children.get(i);
            Element childParent = XmlToolkit.createElement((Element)parentNode, (String)child.getComponentTag());
            child.exportToXml(childParent);
            ++i;
        }
    }

    public String getComponentTag() {
        return COMPONENT_TAG;
    }

    public void initializeFromXml(Element node) {
        if (this.m_name == null || !this.isRootChild()) {
            this.m_name = XmlToolkit.getSetting((Element)node, (String)"folder_name", (String)Messages.JRockitBrowserFolderNode_FOLDER_NAME_DEFAULT);
        }
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            Node n = node.getChildNodes().item(i);
            if (n.getNodeType() == 1) {
                AbstractConnectionDescriptorNode bnode = null;
                if (this.getComponentTag().equals(n.getNodeName())) {
                    bnode = new ConnectionDescriptorFolderNode(this, "");
                } else if ("connector_node".equals(n.getNodeName())) {
                    bnode = new ConnectionDescriptorNode(this, null);
                }
                if (bnode != null) {
                    this.m_children.add(bnode);
                    try {
                        bnode.initializeFromXml((Element)n);
                    }
                    catch (Exception e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JRockitBrowserFolderNode_ERROR_MESSAGE_INITIALIZING, e);
                        this.m_children.remove(bnode);
                    }
                }
            }
            ++i;
        }
    }

    public void addChild(IConnectionDescriptorNode node) {
        node.setParent(this);
        this.m_children.add(node);
        Iterator iter = AbstractConnectionDescriptorNode.getConnectionDescriptors(node).iterator();
        while (iter.hasNext()) {
            RJMXPlugin.getDefault().getDescriptorRepository().add((IConnectionDescriptor)iter.next());
        }
        ConnectionDescriptorFolderNode.getNodeStructureChangeContext().refreshTree();
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return null;
    }
}

