/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.connections.internal;

import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.NodeStructureChangeContext;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractConnectionDescriptorNode
implements IConnectionDescriptorNode {
    protected IConnectionDescriptorNode m_parent;
    private static NodeStructureChangeContext nodeStructureChangeContext;

    public IConnectionDescriptorNode getParent() {
        return this.m_parent;
    }

    public void setParent(IConnectionDescriptorNode node) {
        if (this.m_parent != null) {
            this.m_parent.removeChild(this);
        }
        this.m_parent = node;
    }

    public void removeFromParent() {
        this.m_parent.removeChild(this);
        this.updateTree();
    }

    public int getLevel() {
        if (this.m_parent == null) {
            return 0;
        }
        return this.m_parent.getLevel() + 1;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected void updateTree() {
        AbstractConnectionDescriptorNode.getNodeStructureChangeContext().refreshTree();
        AbstractConnectionDescriptorNode.getNodeStructureChangeContext().recomputeActionEnablement();
    }

    public static Set getConnectionDescriptors(IConnectionDescriptorNode node) {
        HashSet set = new HashSet();
        AbstractConnectionDescriptorNode.getConnectionDescriptors(node, set);
        return set;
    }

    public static void getConnectionDescriptors(IConnectionDescriptorNode node, HashSet set) {
        if (node.isConnectionNode()) {
            set.add(node.getConnectionDescriptor());
        } else {
            int i = 0;
            int size = node.getChildCount();
            while (i < size) {
                AbstractConnectionDescriptorNode.getConnectionDescriptors(node.getChildAt(i), set);
                ++i;
            }
        }
    }

    public static void setNodeStructureChangeContext(NodeStructureChangeContext nodeStructureChangeContext) {
        AbstractConnectionDescriptorNode.nodeStructureChangeContext = nodeStructureChangeContext;
    }

    public static NodeStructureChangeContext getNodeStructureChangeContext() {
        return nodeStructureChangeContext;
    }
}

