/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core;

import com.jrockit.mc.common.security.IMasterPasswordChangedListener;
import com.jrockit.mc.common.security.SecurityManagerFactory;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.rjmx.DescriptorRepository;
import com.jrockit.mc.rjmx.IConnectionManager;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository;
import com.jrockit.mc.rjmx.core.internal.PersistenceSettingsManager;
import com.jrockit.mc.rjmx.core.internal.TriggerModel;
import com.jrockit.mc.rjmx.core.triggers.extension.internal.TriggerFactory;
import com.jrockit.mc.rjmx.internal.RJMX;
import com.jrockit.mc.rjmx.notification.INotificationFactory;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings;
import com.jrockit.mc.rjmx.subscription.internal.AttributeMetaDataManager;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public final class RJMXPlugin
extends Plugin {
    private static final String PLUGIN_ID = "com.jrockit.mc.rjmx.core";
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx.core");
    private static RJMXPlugin plugin;
    private ConnectionDescriptorRepository connectionDescriptorRepository;
    private RJMX rjmx;
    private ScopedPreferenceStore preferenceStore;
    private TriggerModel triggerModel;
    private File rjmxSettingsFile;
    private PersistenceSettingsManager m_persistenceSettingsManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PersistenceSettings.setDefaultDirectory((File)this.getPersistenceDirectory());
        this.rjmx = new RJMX();
        TriggerFactory tf = new TriggerFactory();
        tf.initializeFactory();
        this.rjmx.getNotificationRepository().setFactory((INotificationFactory)tf);
        this.rjmxSettingsFile = this.getConsoleModelSettingsFile();
        this.rjmx.initializeSettings(this.rjmxSettingsFile);
        this.triggerModel = new TriggerModel();
        this.triggerModel.doLoad();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.internal.PersistenceSettingsManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((PersistenceSettingsManager)this.getService(clazz)).initPersistenceSettings();
        SecurityManagerFactory.getSecurityManager().addMasterPasswordChangedListener(new IMasterPasswordChangedListener(){

            public void passwordChanged(int type) {
                RJMXPlugin.this.rjmx.getDescriptorRepository().clearPasswords();
            }
        });
        this.connectionDescriptorRepository = new ConnectionDescriptorRepository();
        this.connectionDescriptorRepository.loadSettings();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.preferenceStore != null) {
            this.preferenceStore.save();
        }
        this.rjmx.exportSettings(this.rjmxSettingsFile);
        plugin = null;
        super.stop(context);
        this.rjmx = null;
    }

    private File getConsoleModelSettingsFile() {
        String rjmxSettingsFileName = "rjmx." + MCVersion.getFullVersion() + ".xml";
        return new File(CorePlugin.getDefault().getWorkspaceDirectory(), rjmxSettingsFileName);
    }

    private File getPersistenceDirectory() {
        File persistenceDirectory = new File(this.getStateLocation().toFile(), "persist");
        try {
            if (persistenceDirectory.exists()) {
                return persistenceDirectory;
            }
            if (persistenceDirectory.mkdir() && persistenceDirectory.exists()) {
                return persistenceDirectory;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print("Warning! Persistence directory " + persistenceDirectory.getAbsolutePath() + " could not be created");
        System.out.println("Will use workspace direcory " + CorePlugin.getDefault().getWorkspaceDirectory() + " for persistence instead.");
        return CorePlugin.getDefault().getWorkspaceDirectory();
    }

    public static RJMXPlugin getDefault() {
        return plugin;
    }

    public synchronized IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    private ConnectionDescriptorRepository getBrowserModelInternal() {
        return this.connectionDescriptorRepository;
    }

    private PersistenceSettingsManager getPersistenceSettingsManagerInternal() {
        if (this.m_persistenceSettingsManager == null) {
            this.m_persistenceSettingsManager = new PersistenceSettingsManager(this.getPreferenceStore(), this.rjmx.getPersistenceSettings());
        }
        return this.m_persistenceSettingsManager;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    private TriggerModel getTriggerModelInternal() {
        return this.triggerModel;
    }

    private AttributeMetaDataManager getMetaDataManagerInternal() {
        return this.rjmx.getMetaDataManager();
    }

    public IConnectionManager getConnectionManager() {
        return this.rjmx.getConnectionManager();
    }

    public DescriptorRepository getDescriptorRepository() {
        return this.rjmx.getDescriptorRepository();
    }

    public Object getService(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.jrockit.mc.rjmx.notification.internal.NotificationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.rjmx.getNotificationRepository();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.jrockit.console.jdp.JDPClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return this.rjmx.getJDPClient();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return this.rjmx.getPersistenceSettings();
        }
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("com.jrockit.mc.rjmx.core.internal.PersistenceSettingsManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz5) {
            return this.getPersistenceSettingsManagerInternal();
        }
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("com.jrockit.mc.rjmx.subscription.internal.AttributeMetaDataManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz6) {
            return this.getMetaDataManagerInternal();
        }
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz7) {
            return this.getBrowserModelInternal();
        }
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("com.jrockit.mc.rjmx.core.internal.TriggerModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz8) {
            return this.getTriggerModelInternal();
        }
        return null;
    }
}

