/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.Messages;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.console.ui.system.SystemPropertiesSectionPart;
import com.jrockit.mc.core.ui.VerticalSectionLayout;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RuntimeTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_RUNTIME_DATA = "runtimeData";
    private CombinedChartSectionPart processorChartPart;
    private AttributeFieldTableSectionPart systemPart;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout((Layout)new VerticalSectionLayout());
        this.addRefreshAction((ContributionManager)form.getToolBarManager());
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.RuntimeTab_SECTION_PROCESSOR_USAGE_TEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.system.help_ProcessorUsage");
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_Y, (Object)"%");
        this.processorChartPart = (CombinedChartSectionPart)guiBuilder.createChart();
        guiBuilder.clearProperties();
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.RuntimeTab_SECTION_SYSTEM_STATISTICS_TEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.system.help_Statistics");
        this.systemPart = (AttributeFieldTableSectionPart)guiBuilder.createTable();
        SystemPropertiesSectionPart sysProp = new SystemPropertiesSectionPart(form.getBody(), managedForm.getToolkit());
        sysProp.getSection().setText(Messages.RuntimeTab_SECTION_SYSTEM_PROPERTIES_TEXT);
        managedForm.addPart((IFormPart)sysProp);
        if (!this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_RUNTIME_DATA, this)) {
            this.initializeDefaultAttributes();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_RUNTIME_DATA, this);
    }

    private void addRefreshAction(ContributionManager manager) {
        manager.insert(0, (IContributionItem)new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                RuntimeTab.this.initializeDefaultAttributes();
            }
        }));
        manager.update(true);
    }

    private void initializeDefaultAttributes() {
        this.initializeProcessorChartPart();
        this.initializeSystemPart();
    }

    private void initializeProcessorChartPart() {
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.processorChartPart.clear();
        this.processorChartPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_CPU_LOAD));
        this.processorChartPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_JVM_CPU_LOAD));
    }

    private void initializeSystemPart() {
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.systemPart.clear();
        this.systemPart.add(new AttributeDescriptor("java.lang:type=Runtime", "VmVersion"));
        this.systemPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_AVAILABLE_PROCESSORS));
        this.systemPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.THREAD_THREAD_COUNT));
        this.systemPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.CLASSLOADING_LOADED_CLASS_COUNT));
        this.systemPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.RUNTIME_START_TIME));
        this.systemPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.RUNTIME_UPTIME));
    }

    public String getComponentTag() {
        return "SystemTab";
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getDescriptor().getGUID());
        this.processorChartPart.exportToXml(e);
        this.systemPart.exportToXml(e);
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeProcessChartFromXml(node);
        this.initializeSystemPartFromXml(node);
    }

    private void initializeSystemPartFromXml(Element node) {
        List list = XmlToolkit.getChildNodesByTag((Node)node, (String)"AttribubteTableSectionPart");
        if (this.hasOneElement(list)) {
            this.safeInitialize((XmlEnabled)this.systemPart, (Element)list.get(0));
        } else {
            this.initializeSystemPart();
        }
    }

    private void initializeProcessChartFromXml(Element node) {
        List list = XmlToolkit.getChildNodesByTag((Node)node, (String)"CombinedChartSectionPart");
        if (this.hasOneElement(list)) {
            this.safeInitialize((XmlEnabled)this.processorChartPart, (Element)list.get(0));
        } else {
            this.initializeProcessorChartPart();
        }
    }

    private boolean hasOneElement(List list) {
        return list != null && list.size() == 1;
    }
}

