/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.Messages;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ui.VerticalSectionLayout;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MemoryTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_MEMORY_DATA = "memoryData";
    private CombinedChartSectionPart memoryChartPart;
    private AttributeFieldTableSectionPart memoryPart;
    private AttributeFieldTableSectionPart gcPart;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        VerticalSectionLayout layout = new VerticalSectionLayout();
        form.getBody().setLayout((Layout)layout);
        ((ContributionManager)form.getToolBarManager()).insert(0, (IContributionItem)new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                MemoryTab.this.initializeDefaultAttributes();
            }
        }));
        form.getToolBarManager().update(true);
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.MemoryTab_SECTION_HEAP_TEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.system.help_Heap");
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_Y, (Object)"%");
        this.memoryChartPart = (CombinedChartSectionPart)guiBuilder.createChart();
        guiBuilder.clearProperties();
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.MemoryTab_SECTION_MEMORY_STATISTICS_TEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.system.help_MemoryStatistics");
        this.memoryPart = (AttributeFieldTableSectionPart)guiBuilder.createTable();
        guiBuilder.clearProperties();
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.MemoryTab_SECTION_GARBAGE_COLLECTOR_TEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.system.help_GC");
        this.gcPart = (AttributeFieldTableSectionPart)guiBuilder.createTable();
        this.gcPart.getMCToolBarManager().add((IAction)new GCAction());
        boolean initialized = this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORY_DATA, this);
        if (!initialized) {
            this.initializeDefaultAttributes();
        }
        this.gcPart.getSection().layout(true, true);
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORY_DATA, this);
    }

    private void initializeDefaultAttributes() {
        this.initializeMemoryChart();
        this.initializeMemoryTable();
        this.initializeGCTable();
    }

    private void initializeGCTable() {
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.gcPart.clear();
        this.gcPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.GARBAGE_COLLECTOR_HEURISTIC_NAME));
        this.gcPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.GARBAGE_COLLECTOR_NAME));
        this.gcPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.GARBAGE_COLLECTOR_STRATEGY_DESCRIPTION));
        this.gcPart.add(new AttributeDescriptor("oracle.jrockit.management:type=PerfCounters", "jrockit.gc.latest.oc.sumOfPauses"));
        this.gcPart.add(new AttributeDescriptor("oracle.jrockit.management:type=PerfCounters", "jrockit.gc.latest.yc.sumOfPauses"));
        this.gcPart.add(new AttributeDescriptor("oracle.jrockit.management:type=PerfCounters", "jrockit.gc.latest.oc.compaction.time"));
    }

    private void initializeMemoryTable() {
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.memoryPart.clear();
        this.memoryPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_PHYSICAL_FREE));
        this.memoryPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_PHYSICAL_USED));
        this.memoryPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_HEAP_FREE));
        this.memoryPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_HEAP_USED));
        this.memoryPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_ALLOCATED_HEAP_SIZE));
    }

    private void initializeMemoryChart() {
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.memoryChartPart.clear();
        this.memoryChartPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_PHYSICAL_USED_PERCENT));
        this.memoryChartPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_HEAP_USED_PERCENT));
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getDescriptor().getGUID());
        this.memoryChartPart.exportToXml(e);
        this.memoryPart.exportToXml(e);
        this.gcPart.exportToXml(e);
    }

    public String getComponentTag() {
        return "MemoryTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeMemoryChartFromXml(node);
        this.initializeTablesFromXml(node);
    }

    private void initializeTablesFromXml(Element node) {
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)"AttribubteTableSectionPart");
        if (l != null && l.size() == 2) {
            this.safeInitialize((XmlEnabled)this.memoryPart, (Element)l.get(0));
            this.safeInitialize((XmlEnabled)this.gcPart, (Element)l.get(1));
        } else {
            this.initializeMemoryTable();
            this.initializeGCTable();
        }
    }

    private void initializeMemoryChartFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)"CombinedChartSectionPart");
        if (l != null && l.size() == 1) {
            this.safeInitialize((XmlEnabled)this.memoryChartPart, (Element)l.get(0));
        } else {
            this.initializeMemoryChart();
        }
    }

    class GCAction
    extends Action {
        public GCAction() {
            super(Messages.MemoryTab_RUN_GC_ACTION_TEXT, 1);
            this.setText(Messages.MemoryTab_RUN_GC_ACTION_TEXT);
            this.setToolTipText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("trash.png"));
        }

        public void run() {
            try {
                MemoryTab.this.getMBeanService().getProxyOperations().gc();
            }
            catch (UnsupportedOperationException o) {
                SystemPlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)MemoryTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (String)Messages.MemoryTab_MESSAGE_COULD_NOT_RUN_GC, (Throwable)o);
            }
            catch (IOException o) {
                SystemPlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)MemoryTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (Throwable)o);
            }
        }
    }
}

