/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.storage;

import com.jrockit.mc.flightrecorder.internal.api.storage.Compressed64Storage;
import com.jrockit.mc.flightrecorder.internal.api.storage.IStorage;
import com.jrockit.mc.flightrecorder.internal.api.storage.IStorageBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaiveCompressed64StorageBuilder
implements IStorageBuilder {
    private List<Integer> m_objects = new ArrayList<Integer>();
    private Map<Object, Integer> m_objectMap = new HashMap<Object, Integer>();
    private int m_objectCount;

    public void add(Object object) {
        Integer index = this.m_objectMap.get(object);
        if (index == null) {
            index = this.m_objectCount;
            this.m_objectMap.put(object, this.m_objectCount);
            ++this.m_objectCount;
        }
        this.m_objects.add(index);
    }

    public IStorage createStorage() {
        int[] values = new int[this.m_objects.size()];
        int index = 0;
        for (Integer i : this.m_objects) {
            values[index] = i;
            ++index;
        }
        return new Compressed64Storage(values, this.m_objectMap.keySet().toArray());
    }

    public int getSize() {
        return this.m_objectCount;
    }
}

