/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.storage;

import com.jrockit.mc.flightrecorder.internal.api.storage.IStorage;

public class Compressed64Storage
implements IStorage {
    private final long[] m_words;
    private final Object[] m_objects;
    private final int SIXTY_FOUR_MINUS_BITDEPTH;
    private final int m_bitDepth;
    private final int ONE_TWENTY_EIGHT_MINUS_BITDEPTH;
    private static final int MODULUS_64_BITMASK = 63;
    private static final int DIVIDE_64_SHIFT = 6;

    Compressed64Storage(int[] values, Object[] objects) {
        this.m_objects = objects;
        this.m_bitDepth = Compressed64Storage.calculateBithDepth(objects.length - 1);
        this.SIXTY_FOUR_MINUS_BITDEPTH = 64 - this.m_bitDepth;
        this.ONE_TWENTY_EIGHT_MINUS_BITDEPTH = 128 - this.m_bitDepth;
        this.m_words = this.createsWords(values, this.m_bitDepth);
    }

    public static int calculateBithDepth(int size) {
        int depth = 0;
        while (true) {
            ++depth;
            if (size == 1) {
                return depth;
            }
            size /= 2;
        }
    }

    private long[] createsWords(int[] values, int bitDepth) {
        long[] bits = new long[values.length * bitDepth / 64 + 2];
        int bitIndex = 0;
        int n = 0;
        while (n < values.length) {
            int lowBitIndex = bitIndex & 0x3F;
            int index = bitIndex >>> 6;
            if (lowBitIndex <= this.SIXTY_FOUR_MINUS_BITDEPTH) {
                long value = values[n];
                bits[index] = bits[index] | value << 64 - lowBitIndex - bitDepth;
            } else {
                int value = values[n];
                int firstShift = value >>> this.SIXTY_FOUR_MINUS_BITDEPTH + lowBitIndex;
                int secondsShift = value << lowBitIndex;
                int n2 = index;
                bits[n2] = bits[n2] + (long)firstShift;
                bits[index + 1] = secondsShift;
            }
            bitIndex += bitDepth;
            ++n;
        }
        return bits;
    }

    public Object getObject(int position) {
        return this.m_objects[this.getIndex(position)];
    }

    public int getIndex(int position) {
        int bitPosition = this.m_bitDepth * position;
        int bitIndex = bitPosition & 0x3F;
        if (bitIndex <= this.SIXTY_FOUR_MINUS_BITDEPTH) {
            return (int)(this.m_words[bitPosition >>> 6] << bitIndex >>> this.SIXTY_FOUR_MINUS_BITDEPTH);
        }
        long left = this.m_words[bitPosition >>> 6] << bitIndex >>> this.SIXTY_FOUR_MINUS_BITDEPTH;
        long right = this.m_words[(bitPosition >>> 6) + 1] >>> this.ONE_TWENTY_EIGHT_MINUS_BITDEPTH - bitIndex;
        return (int)(left | right);
    }
}

