/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.range;

import com.jrockit.mc.flightrecorder.internal.api.range.IPriorityProvider;
import java.util.Iterator;

public final class PriorityIterator
implements Iterator {
    private final HeapItem[] m_items;
    private int count = 0;

    public PriorityIterator(Iterator[] iterators, IPriorityProvider[] provider) {
        this.m_items = new HeapItem[iterators.length + 1];
        int n = 0;
        while (n < iterators.length) {
            this.insert(iterators[n], provider[n]);
            ++n;
        }
    }

    public PriorityIterator(Iterator[] iterators, IPriorityProvider provider) {
        this.m_items = new HeapItem[iterators.length + 1];
        int n = 0;
        while (n < iterators.length) {
            this.insert(iterators[n], provider);
            ++n;
        }
    }

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.count > 0;
    }

    public Object next() {
        HeapItem item = this.m_items[1];
        Iterator it = item.iterator;
        Object result = item.value;
        if (it.hasNext()) {
            item.value = it.next();
            item.priority = item.provider.getPriority(item.value);
            this.moveDown(1);
        } else {
            this.removeTop();
        }
        return result;
    }

    private void removeTop() {
        PriorityIterator.swap(this.m_items, 1, this.count);
        --this.count;
        this.moveDown(1);
    }

    private void insert(Iterator it, IPriorityProvider provider) {
        if (it.hasNext()) {
            ++this.count;
            HeapItem item = new HeapItem(it, provider);
            item.value = it.next();
            item.priority = provider.getPriority(item.value);
            this.m_items[this.count] = item;
            this.moveUp(this.count);
        }
    }

    private void moveUp(int i) {
        if (i > 1 && this.m_items[i].priority < this.m_items[i / 2].priority) {
            PriorityIterator.swap(this.m_items, i, i / 2);
            this.moveUp(i / 2);
        }
    }

    private void moveDown(int i) {
        int child = 2 * i;
        if (child < this.count && this.m_items[child + 1].priority < this.m_items[child].priority) {
            ++child;
        }
        if (child <= this.count && this.m_items[i].priority > this.m_items[child].priority) {
            PriorityIterator.swap(this.m_items, i, child);
            this.moveDown(child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HeapItem<Type> {
        private final Iterator<Type> iterator;
        private final IPriorityProvider<Type> provider;
        private long priority;
        private Type value;

        HeapItem(Iterator<Type> iterator, IPriorityProvider<Type> provider) {
            this.iterator = iterator;
            this.provider = provider;
        }
    }
}

