/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.range;

import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DisjointRangeIterator
implements Iterator<Object> {
    private final IRange[] m_range;
    private final IRangeFilter m_filter;
    private final int m_lastIndex;
    private int m_index = -1;
    private int m_endIndex = -2;

    public DisjointRangeIterator(IRange[] range, IRangeFilter filter, RangeSelection rs, long startTime, long endTime) {
        this.m_range = range;
        this.m_lastIndex = this.m_range.length - 1;
        this.m_filter = filter;
        if (this.m_range.length == 0) {
            this.setHasNoNext();
            return;
        }
        if (this.m_range[0].getStartTimestamp() > endTime || this.m_range[this.m_lastIndex].getEndTimestamp() < startTime) {
            this.setHasNoNext();
            return;
        }
        this.m_index = this.m_range[0].getEndTimestamp() >= startTime ? this.addDelta(0, rs.getStartIndexDelta()) : this.addDelta(this.getStartIndex(startTime), rs.getStartIndexDelta());
        this.m_endIndex = this.m_range[this.m_lastIndex].getStartTimestamp() <= endTime ? this.addDelta(this.m_lastIndex, rs.getEndIndexDelta()) : this.addDelta(this.getEndIndex(endTime), rs.getEndIndexDelta());
    }

    private int addDelta(int index, int delta) {
        return Math.min(this.m_lastIndex, Math.max(0, index + delta));
    }

    private void setHasNoNext() {
        this.m_index = 1;
        this.m_endIndex = 0;
    }

    private int getStartIndex(long startTime) {
        int index = this.binarySearch(startTime, true);
        if (this.m_range[index].getEndTimestamp() >= startTime) {
            return index;
        }
        return index + 1;
    }

    private int getEndIndex(long endTime) {
        int index = this.binarySearch(endTime, false);
        if (this.m_range[index].getStartTimestamp() <= endTime) {
            return index;
        }
        return index - 1;
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            return this.m_range[this.m_index++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        while (this.m_index <= this.m_endIndex) {
            if (this.m_filter.accept(this.m_range[this.m_index])) {
                return true;
            }
            ++this.m_index;
        }
        return false;
    }

    private int binarySearch(long value, boolean useEndValue) {
        int low = 0;
        int high = this.m_lastIndex;
        int middle = -1;
        while (low <= high) {
            long v;
            middle = low + high >>> 1;
            long l = v = useEndValue ? this.m_range[middle].getEndTimestamp() : this.m_range[middle].getStartTimestamp();
            if (v == value) {
                return middle;
            }
            if (v < value) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return low;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove events from range.");
    }
}

