/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.range;

import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.internal.api.range.ArrayIterator;
import com.jrockit.mc.flightrecorder.internal.api.range.DisjointRangeIterator;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjointRangeHolder
implements IRangeHolder {
    private static final int PRERAPED_FOR_ITERATION = Integer.MAX_VALUE;
    private static final IRange[] EMPTY_RANGE_ARRAY = new IRange[0];
    private static final int CAPACITY = 64;
    private IRange[] m_rangeArray = EMPTY_RANGE_ARRAY;
    private IRange[] m_currentArray = EMPTY_RANGE_ARRAY;
    private int m_currentIndex = Integer.MAX_VALUE;
    private LinkedList<Object> m_linkedArrayList;

    @Override
    public boolean isEmpty() {
        this.prepareToIterate();
        return this.m_rangeArray == null || this.m_rangeArray.length == 0;
    }

    @Override
    public Iterator<Object> iterator(IRangeFilter filter, IRange range, RangeSelection rs) {
        this.prepareToIterate();
        if (range == IRange.INFINITE_RANGE && filter == IRangeHolder.ALWAYS_TRUE_FILTER && rs == RangeSelection.NORMAL) {
            return new ArrayIterator<Object>(this.m_rangeArray);
        }
        return new DisjointRangeIterator(this.m_rangeArray, filter, rs, range.getStartTimestamp(), range.getEndTimestamp());
    }

    @Override
    public Iterator<Object> iterator() {
        this.prepareToIterate();
        return new ArrayIterator<Object>(this.m_rangeArray);
    }

    @Override
    public void add(IRange range) {
        if (this.m_currentIndex < this.m_currentArray.length) {
            this.m_currentArray[this.m_currentIndex++] = range;
        } else {
            if (this.m_currentIndex == Integer.MAX_VALUE) {
                this.m_linkedArrayList = new LinkedList();
            } else {
                this.m_linkedArrayList.add(this.m_currentArray);
            }
            this.m_currentArray = new IRange[64];
            this.m_currentArray[0] = range;
            this.m_currentIndex = 1;
        }
    }

    @Override
    public void addAll(Collection<IRange> c) {
        throw new UnsupportedOperationException("AddAll is not supported");
    }

    @Override
    public void clear() {
        this.m_linkedArrayList = null;
        this.m_rangeArray = EMPTY_RANGE_ARRAY;
        this.m_currentArray = null;
        this.m_currentIndex = Integer.MAX_VALUE;
    }

    private void prepareToIterate() {
        if (this.m_currentIndex != Integer.MAX_VALUE) {
            int newSize = this.m_linkedArrayList.size() > 0 ? 64 * this.m_linkedArrayList.size() : 0;
            int index = 0;
            this.m_linkedArrayList.add(this.m_currentArray);
            IRange[] result = new IRange[newSize += this.m_currentIndex];
            if (!this.m_linkedArrayList.isEmpty()) {
                Object last = this.m_linkedArrayList.getLast();
                int c = this.m_currentIndex;
                for (Object e : this.m_linkedArrayList) {
                    if (e != last) {
                        System.arraycopy(e, 0, result, index, 64);
                    } else {
                        System.arraycopy(e, 0, result, index, c);
                    }
                    index += 64;
                }
            }
            this.m_rangeArray = result;
            this.m_linkedArrayList = null;
            this.m_currentArray = null;
            this.m_currentIndex = Integer.MAX_VALUE;
        }
    }

    @Override
    public IRange getFirst() {
        this.prepareToIterate();
        if (this.m_rangeArray.length > 0) {
            return this.m_rangeArray[0];
        }
        return null;
    }

    @Override
    public IRange getLast() {
        this.prepareToIterate();
        if (this.m_rangeArray.length > 0) {
            return this.m_rangeArray[this.m_rangeArray.length - 1];
        }
        return null;
    }
}

