/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.factories;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptorToolkit;
import com.jrockit.mc.flightrecorder.internal.api.factories.EqualityProxy;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRStackTrace;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;
import java.util.HashMap;

public final class StackTraceFactory
implements IPoolFactory {
    private final int m_frameIndex;
    private final int m_methodIndex;
    private final int m_lineNumberIndex;
    private final int m_frameTypeIndex;
    private final HashMap<EqualityProxy<FLRStackTrace>, EqualityProxy<FLRStackTrace>> m_map = new HashMap();

    public StackTraceFactory(ValueDescriptor[] traceDescriptors) {
        this.m_frameIndex = ValueDescriptorToolkit.getIndex(traceDescriptors, "frames");
        if (this.m_frameIndex != -1) {
            ValueDescriptor frameDescriptor = traceDescriptors[this.m_frameIndex];
            this.m_methodIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "method");
            this.m_lineNumberIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "line");
            this.m_frameTypeIndex = ValueDescriptorToolkit.getIndex(frameDescriptor.getChildren(), "type");
        } else {
            this.m_methodIndex = -1;
            this.m_lineNumberIndex = -1;
            this.m_frameTypeIndex = -1;
        }
    }

    public Object createObject(long identifier, Object o) {
        if (o != null) {
            FLRStackTrace t = this.createTrace(o);
            EqualityProxy<FLRStackTrace> newTrace = new EqualityProxy<FLRStackTrace>(t);
            EqualityProxy<FLRStackTrace> oldTrace = this.m_map.get(newTrace);
            if (oldTrace == null) {
                this.m_map.put(newTrace, newTrace);
                return t;
            }
            return oldTrace.getObject();
        }
        return null;
    }

    private FLRStackTrace createTrace(Object o) {
        Object[] frames = (Object[])o;
        FLRFrame[] flrFrames = new FLRFrame[frames.length];
        int n = 0;
        while (n < frames.length) {
            flrFrames[n] = this.createFrame((Object[])frames[n]);
            ++n;
        }
        return new FLRStackTrace(flrFrames);
    }

    private FLRFrame createFrame(Object[] frameObject) {
        FLRFrame frame = new FLRFrame();
        if (this.m_methodIndex != -1) {
            frame.setMethod((IMCMethod)frameObject[this.m_methodIndex]);
        }
        if (this.m_lineNumberIndex != -1) {
            frame.setFrameLineNumber((Integer)frameObject[this.m_lineNumberIndex]);
        }
        if (this.m_frameTypeIndex != -1) {
            frame.setType(this.getType((String)frameObject[this.m_frameTypeIndex]));
        }
        return frame;
    }

    private String getType(String type) {
        if ("Optimized".equals(type)) {
            return "optimized";
        }
        if ("Inlined".equals(type)) {
            return "inlined";
        }
        if ("JIT compiled".equals(type)) {
            return "jitCompiled";
        }
        return null;
    }
}

