/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.factories;

import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptorToolkit;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRMethod;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;

public final class MethodFactory
implements IPoolFactory {
    private final int m_methodClass;
    private final int m_methodName;
    private final int m_methodSignatureIndex;
    private final int m_methodModifiers;

    public MethodFactory(ValueDescriptor[] descriptors) {
        this.m_methodClass = ValueDescriptorToolkit.getIndex(descriptors, "class");
        this.m_methodName = ValueDescriptorToolkit.getIndex(descriptors, "name");
        this.m_methodSignatureIndex = ValueDescriptorToolkit.getIndex(descriptors, "signature");
        this.m_methodModifiers = ValueDescriptorToolkit.getIndex(descriptors, "modifiers");
    }

    public Object createObject(long identifier, Object source) {
        Object[] o = (Object[])source;
        if (o != null) {
            return this.createMethod(o);
        }
        return null;
    }

    private Object createMethod(Object[] o) {
        IMCType type;
        FLRMethod method = new FLRMethod();
        if (this.m_methodSignatureIndex != -1) {
            method.setFormalDescriptor((String)o[this.m_methodSignatureIndex]);
        }
        if (this.m_methodName != -1) {
            method.setMethodName((String)o[this.m_methodName]);
        }
        if (this.m_methodModifiers != -1) {
            Short s = (Short)o[this.m_methodModifiers];
            method.setModifier(s != null ? Integer.valueOf(s.shortValue()) : null);
        }
        if (this.m_methodClass != -1 && (type = (IMCType)o[this.m_methodClass]) != null) {
            method.setPackageName(type.getPackageName());
            method.setClassName(type.getTypeName());
            method.setType(type);
        }
        return method;
    }
}

