/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.factories;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptorToolkit;
import com.jrockit.mc.flightrecorder.internal.api.factories.GCStrategy;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;

public class GCStrategyFactory
implements IPoolFactory {
    private final int m_descriptionIndex;
    private final int m_generationalIndex;
    private final int m_concurrentSweepIndex;
    private final int m_concurrentMarkIndex;

    GCStrategyFactory(ValueDescriptor[] descriptors) {
        this.m_descriptionIndex = ValueDescriptorToolkit.getIndex(descriptors, "desc");
        this.m_generationalIndex = ValueDescriptorToolkit.getIndex(descriptors, "generational");
        this.m_concurrentSweepIndex = ValueDescriptorToolkit.getIndex(descriptors, "consweep");
        this.m_concurrentMarkIndex = ValueDescriptorToolkit.getIndex(descriptors, "conmark");
    }

    public Object createObject(long identifier, Object o) {
        if (o != null) {
            Object[] objectArray = (Object[])o;
            GCStrategy s = new GCStrategy();
            if (this.m_descriptionIndex != -1) {
                s.setDescription((String)objectArray[this.m_descriptionIndex]);
            }
            if (this.m_generationalIndex != -1) {
                s.setGenerational((Boolean)objectArray[this.m_generationalIndex]);
            }
            if (this.m_concurrentSweepIndex != -1) {
                s.setConcurrentSweep((Boolean)objectArray[this.m_concurrentSweepIndex]);
            }
            if (this.m_concurrentMarkIndex != -1) {
                s.setConcurrentMark((Boolean)objectArray[this.m_concurrentMarkIndex]);
            }
            return s;
        }
        return null;
    }
}

