/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.factories;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.factories.GCReasonFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.GCStrategyFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.JavaThreadFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.MethodFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.OSThreadFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.StackTraceFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.ThreadGroupFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.TypeFactory;
import com.jrockit.mc.flightrecorder.internal.api.factories.VMThreadFactory;
import java.util.HashMap;

public class FactoryRepository {
    private final HashMap<String, IPoolFactory> m_factories = new HashMap();

    public IPoolFactory getFactory(ConstantPool pool) {
        String name = pool.getName();
        IPoolFactory factory = this.m_factories.get(name);
        if (factory == null && (factory = this.createFactory(pool)) != null) {
            this.m_factories.put(name, factory);
        }
        return factory;
    }

    public IPoolFactory getFactory(String name) {
        return this.m_factories.get(name);
    }

    private IPoolFactory createFactory(ConstantPool pool) {
        String name = pool.getName();
        ValueDescriptor[] descs = pool.getValueDescriptors();
        if ("Method".equals(name)) {
            return new MethodFactory(descs);
        }
        if ("StackTrace".equals(name)) {
            return new StackTraceFactory(descs);
        }
        if ("JavaThread".equals(name)) {
            return new JavaThreadFactory(descs);
        }
        if ("Thread".equals(name)) {
            return new OSThreadFactory();
        }
        if ("VMThread".equals(name)) {
            return new VMThreadFactory();
        }
        if ("Class".equals(name)) {
            return new TypeFactory(descs);
        }
        if ("ThreadGroup".equals(name)) {
            return new ThreadGroupFactory(pool.getValueDescriptors());
        }
        if ("GCStrategy".equals(name)) {
            return new GCStrategyFactory(descs);
        }
        if ("GCReason".equals(name)) {
            return new GCReasonFactory(descs);
        }
        return null;
    }
}

