/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.factories;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.api.EqualsToolkit;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.api.factories.IHashable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLRStackTrace
implements IMCStackTrace,
IHashable<FLRStackTrace> {
    private final List<FLRFrame> m_list;
    private final int m_hashCode;
    private final FLRFrame m_topFrame;

    FLRStackTrace(FLRFrame[] frames) {
        this.m_list = Arrays.asList(frames);
        this.m_topFrame = this.createTopFrame(frames);
        this.m_hashCode = this.calcMethodHash();
    }

    private int calcMethodHash() {
        int hash = 23;
        int size = this.m_list.size();
        int n = 0;
        while (n < size) {
            IMCFrame a = (IMCFrame)this.m_list.get(n);
            if (a != null) {
                hash = EqualsToolkit.hash(hash, a.getMethod());
            }
            ++n;
        }
        return hash;
    }

    private FLRFrame createTopFrame(FLRFrame[] frames) {
        if (frames.length > 0 && frames[0] != null && frames[0].getMethod() != null) {
            return frames[0];
        }
        return null;
    }

    public FLRFrame getValidTopFrame() {
        return this.m_topFrame;
    }

    public List<? extends IMCFrame> getFrames() {
        return this.m_list;
    }

    @Override
    public int calculateHashCode() {
        return this.m_hashCode;
    }

    @Override
    public boolean isEqual(FLRStackTrace t) {
        if (t == this) {
            return true;
        }
        List<? extends IMCFrame> thatFrames = t.getFrames();
        int thatSize = thatFrames.size();
        if (thatSize == this.m_list.size()) {
            int n = 0;
            while (n < thatSize) {
                IMCFrame a = (IMCFrame)this.m_list.get(n);
                IMCFrame b = thatFrames.get(n);
                if (a != null && b != null ? !EqualsToolkit.nullSafeEquals(a.getMethod(), b.getMethod()) : a != b) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

