/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.IndexedValueRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRStackTrace;
import com.jrockit.mc.flightrecorder.spi.IEvent;

public final class TopFramePackageRetriever
extends IndexedValueRetriever {
    public TopFramePackageRetriever(String path, String attributeIdentifier, int index) {
        super(TopFramePackageRetriever.createDesciptor(attributeIdentifier), path, index);
    }

    private static ValueDescriptor createDesciptor(String attributIdentifier) {
        ValueDescriptor builder = new ValueDescriptor();
        builder.setName("Stacktrace (Top Frame : Package)");
        builder.setDescription("The package the method on top of the stack belongs to.");
        builder.setIdentifier("(" + attributIdentifier + ".package)");
        builder.setDataType(DataType.STRUCT);
        builder.setContentType(UnitLookup.PACKAGE.getIdentifier());
        return builder;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isSynthetic() {
        return true;
    }

    public Object getValue(IEvent event) {
        FLRStackTrace s;
        FLRFrame frame;
        Object o = super.getValue(event);
        if (o instanceof FLRStackTrace && (frame = (s = (FLRStackTrace)o).getValidTopFrame()) != null) {
            String packageName = frame.getMethod().getPackageName();
            if (packageName != null && packageName.length() == 0) {
                return "(default package)";
            }
            return packageName;
        }
        return null;
    }
}

