/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.IndexedValueRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRMethod;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRStackTrace;
import com.jrockit.mc.flightrecorder.spi.IEvent;

public final class TopFrameClassRetriever
extends IndexedValueRetriever {
    public TopFrameClassRetriever(String path, String attributeIdentifier, int index) {
        super(TopFrameClassRetriever.createDesciptor(attributeIdentifier), path, index);
    }

    private static ValueDescriptor createDesciptor(String attributIdentifier) {
        ValueDescriptor builder = new ValueDescriptor();
        builder.setName("Stacktrace (Top Frame : Class)");
        builder.setDescription("The method in top of the stack");
        builder.setIdentifier("(" + attributIdentifier + ".class)");
        builder.setDataType(DataType.STRUCT);
        builder.setContentType(UnitLookup.CLASS.getIdentifier());
        return builder;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isSynthetic() {
        return true;
    }

    public Object getValue(IEvent event) {
        FLRStackTrace s;
        FLRFrame topFrame;
        Object o = super.getValue(event);
        if (o instanceof FLRStackTrace && (topFrame = (s = (FLRStackTrace)o).getValidTopFrame()) != null) {
            return ((FLRMethod)topFrame.getMethod()).getType();
        }
        return null;
    }
}

