/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitGlobalRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrackDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.IEventParserHook;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRThread;
import com.jrockit.mc.flightrecorder.internal.api.factories.OSThreadFactory;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;

public final class ThreadLifetimeHook
implements IEventParserHook {
    private final boolean m_start;

    public ThreadLifetimeHook(boolean start) {
        this.m_start = start;
    }

    public boolean execute(Event e, Environment environment, ITrackRepository trackRepository) {
        FLRThread thread;
        OSThreadFactory f = (OSThreadFactory)environment.getFactory("Thread");
        if (f != null && (thread = (FLRThread)e.getValue("thread")) != null) {
            JRockitTrackDescriptor jtd = ((JRockitGlobalRepository)trackRepository).getThreadTrack(thread);
            if (this.m_start) {
                jtd.setStartTime(e.getStartTimestamp());
                f.setStartTime(thread, e.getStartTimestamp());
            } else {
                jtd.setEndTime(e.getStartTimestamp());
                f.setEndTime(thread, e.getEndTimestamp());
            }
        }
        return true;
    }

    public static void install(Environment environment, IProducer producer, String typePath, boolean start) {
        EventTypeDescriptor etd;
        if (producer.getId() == 1 && (etd = environment.findFirstEventTypeDescriptor(typePath)) != null) {
            etd.setEventParserHook(new ThreadLifetimeHook(start));
        }
    }
}

