/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.IValueTransform;
import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Transition;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.CheckPointIncreaseParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ParserFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synthetics {
    public static final int JROCKIT_PRODUCER_ID = 1;
    public static final int METADATA_EVENT_TYPE_INDEX = 0;
    public static final int CHECK_POINT_EVENT_TYPE_INDEX = 1;
    public static final int LOST_EVENT_TYPE_INDEX = 2;
    public static final int CONTENT_TYPE_POOL_NONE = 0;
    public static final int CONTENT_TYPE_MEMORY = 1;
    public static final int CONTENT_TYPE_EPOCHMILLIS = 2;
    public static final int CONTENT_TYPE_MILLIS = 3;
    public static final int CONTENT_TYPE_NANOS = 4;
    public static final int CONTENT_TYPE_TICKS = 5;
    public static final int CONTENT_TYPE_ADDRESS = 6;
    public static final int CONTENT_TYPE_JVM_THREADID = 7;
    public static final int CONTENT_TYPE_JVM_JAVATHREADID = 8;
    public static final int CONTENT_TYPE_JVM_STACKTRACEID = 9;
    public static final int CONTENT_TYPE_JVM_CLASSID = 10;
    public static final int CONTENT_TYPE_PERCENTAGE = 11;
    public static final int CONTENT_TYPE_JVM_VMTHREADID = 101;
    public static final int CONTENT_TYPE_JVM_METHODID = 105;
    public static final int CONTENT_TYPE_JVM_FIELDID = 106;
    public static final int CONTENT_TYPE_JVM_UTFID = 107;
    private static final String EVENT_THREAD_ID = "thread";
    private static final String START_TIME_ID = "start";
    private static final String STACKTRACE_ID = "stacktrace";
    private static final String END_TIME_ID = "end";
    public static final String GC_PATH = "vm/gc/garbage_collection";
    public static final String JAVA_THREAD_START_PATH = "java/thread_start";
    public static final String JAVA_THREAD_END_PATH = "java/thread_end";
    public static final String VM_LOCK_PROFILE_PATH = "vm/sync/lock_profile";
    public static final String JAVA_LCOK_PROFILE_PATH = "java/statistics/lock_profile";
    public static final int HEAP_USAGE_EVENT_TYPE_ID = 3978;
    public static final int LIVE_SET_EVENT_TYPE_ID = 3979;
    public static final int INITIAL_SYSTEM_PROPERTY_EVENT_TYPE_ID = 3980;
    public static final int INITIAL_ENVIRONMENT_VARIABLE_EVENT_TYPE_ID = 3981;
    public static final int RECORDING_SETTING_EVENT_TYPE_ID = 3982;
    public static final int PROCESS_EVENT_TYPE_ID = 3983;
    public static final int RECORDING_EVENT_TYPE_ID = 3984;

    public static List<ValueDescriptor> createSyntheticDescriptors(EventTypeDescriptor eventTypeDescriptor) {
        ArrayList<ValueDescriptor> valueDescriptors = new ArrayList<ValueDescriptor>(4);
        if (eventTypeDescriptor.hasThread()) {
            valueDescriptors.add(Synthetics.createEventThread());
        }
        if (eventTypeDescriptor.canHaveStacktrace()) {
            valueDescriptors.add(Synthetics.createStacktrace());
        }
        return valueDescriptors;
    }

    private static ValueDescriptor createStacktrace() {
        ValueDescriptor vd = new ValueDescriptor();
        vd.setConstantPoolIndex(9);
        vd.setDataType(DataType.LONG);
        vd.setName("Stacktrace");
        vd.setContentType(STACKTRACE_ID);
        vd.setDescription("");
        vd.setTransition(Transition.None);
        vd.setIdentifier(STACKTRACE_ID);
        return vd;
    }

    private static ValueDescriptor createEventThread() {
        ValueDescriptor vd = new ValueDescriptor();
        vd.setDataType(DataType.U4);
        vd.setConstantPoolIndex(7);
        vd.setName("Event Thread");
        vd.setDescription("");
        vd.setTransition(Transition.None);
        vd.setIdentifier(EVENT_THREAD_ID);
        return vd;
    }

    protected static ValueDescriptor createStartTime() {
        ValueDescriptor vd = new ValueDescriptor();
        vd.setContentType(UnitLookup.TIMESTAMP.getIdentifier());
        vd.setDataType(DataType.LONG);
        vd.setName("Start Time");
        vd.setDescription("");
        vd.setTransition(Transition.None);
        vd.setIdentifier(START_TIME_ID);
        return vd;
    }

    protected static ValueDescriptor createEndTime() {
        ValueDescriptor vd = new ValueDescriptor();
        vd.setContentType(UnitLookup.TIMESTAMP.getIdentifier());
        vd.setDataType(DataType.LONG);
        vd.setName("End Time");
        vd.setDescription("");
        vd.setTransition(Transition.None);
        vd.setIdentifier(END_TIME_ID);
        return vd;
    }

    public static String createContentType(ValueDescriptor vd) {
        int constantPoolIndex = vd.getConstantPoolIndex();
        switch (constantPoolIndex) {
            case 2: {
                return UnitLookup.TIMESTAMP.getIdentifier();
            }
            case 3: 
            case 4: 
            case 5: {
                return UnitLookup.TIMESPAN.getIdentifier();
            }
            case 6: {
                return UnitLookup.ADDRESS.getIdentifier();
            }
            case 7: 
            case 8: 
            case 101: {
                return UnitLookup.THREAD.getIdentifier();
            }
            case 10: {
                return UnitLookup.CLASS.getIdentifier();
            }
            case 11: {
                return UnitLookup.PERCENTAGE.getIdentifier();
            }
        }
        switch (vd.getDataType()) {
            case BYTE: 
            case U1: 
            case SHORT: 
            case U2: 
            case U4: 
            case LONG: {
                return UnitLookup.COUNT.getIdentifier();
            }
            case UTF8: 
            case STRING: {
                return UnitLookup.PLAIN_TEXT.getIdentifier();
            }
        }
        return UnitLookup.UNKNOWN.getIdentifier();
    }

    public static int deduceRelationIndex(DataType dataType, int dataStructureIndex) {
        if (dataType.isPrimitive() && dataStructureIndex > 0) {
            return dataStructureIndex - 1;
        }
        return -1;
    }

    public static int deduceConstantPoolIndex(int poolIndex) {
        if (poolIndex <= 11 || poolIndex == 100 || poolIndex <= 105 && poolIndex <= 107) {
            return -1;
        }
        return poolIndex;
    }

    public static void createBufferLostEventType(Producer producer, Environment environment) {
        EventTypeDescriptor descriptor;
        if (producer.getId() == 1 && (descriptor = environment.getEventTypeDescriptor(2)).getEventType() == null) {
            descriptor.setHasThread(true);
            descriptor.setCanhavestacktrace(false);
            descriptor.setIsRequestable(false);
            descriptor.setHasStartTime(false);
            descriptor.setName("Lost Events");
            descriptor.setDescription("Event emitted when the buffer overflows in the JVM.");
            descriptor.setPath("recordings/buffer_lost");
            ValueDescriptor[] descriptors = new ValueDescriptor[]{Synthetics.createEventThread(), new ValueDescriptor()};
            descriptors[1].setName("Memory dropped");
            descriptors[1].setDescription("The amount of memory that was dropped because the event buffer wasn't flushed.");
            descriptors[1].setIdentifier("");
            descriptors[1].setDataType(DataType.LONG);
            descriptors[1].setContentType(UnitLookup.MEMORY.getIdentifier());
            descriptor.setValueDescriptors(descriptors);
            OptimizedEventType type = OptimizedEventType.create(producer, descriptor);
            descriptor.setEventType(type);
            ParserFactory factory = new ParserFactory(environment);
            descriptor.setParsers(factory.createParsers(descriptors, false));
            producer.addEventType(type);
        }
    }

    public static EventTypeDescriptor createCheckPoint(Environment environment) {
        EventTypeDescriptor descriptor = new EventTypeDescriptor(1);
        IParser[] parsers = new IParser[]{new CheckPointIncreaseParser(environment)};
        descriptor.setParsers(parsers);
        return descriptor;
    }

    public static Number deduceFactor(int poolIndex) {
        if (poolIndex == 3) {
            return 1000000L;
        }
        if (poolIndex == 2) {
            return 1000000L;
        }
        return null;
    }

    public static void createTransformation(String eventTypePath, String sourceAttribute, String destinationAttribute, IValueTransform valueTransform) {
    }
}

