/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.IEventParserHook;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;

public final class InitialTimedEventRemover
implements IEventParserHook {
    private final long m_nanosEpsilon;
    private long m_validFromTime = Long.MAX_VALUE;

    public InitialTimedEventRemover(long nanosEpsilon) {
        this.m_nanosEpsilon = nanosEpsilon;
    }

    public boolean execute(Event e, Environment environment, ITrackRepository trackRepository) {
        if (this.m_validFromTime == Long.MAX_VALUE) {
            this.m_validFromTime = e.getStartTimestamp() + this.m_nanosEpsilon;
            return false;
        }
        return e.getStartTimestamp() > this.m_validFromTime;
    }

    public static void install(Environment environment, IProducer producer, String typePath, long length) {
        EventTypeDescriptor etd;
        if (producer.getId() == 1 && (etd = environment.findFirstEventTypeDescriptor(typePath)) != null) {
            etd.setEventParserHook(new InitialTimedEventRemover(length));
        }
    }
}

