/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.flightrecorder.api.Retriever;
import com.jrockit.mc.flightrecorder.api.RetriverToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRetriever;

public final class HeapFragmentationExtension {
    public static void extend(IEventType type) {
        if (type.getPath().equals("vm/gc/heap_statistics/blocks")) {
            IRetriever fragmented = type.getRetriever("darkMatter:size");
            IRetriever used = type.getRetriever("totalHeap:size");
            if (fragmented != null && used != null) {
                type.addRetriever(HeapFragmentationExtension.createRetriever(fragmented, used));
            }
        }
    }

    private static IRetriever createRetriever(final IRetriever fragmented, final IRetriever used) {
        ValueDescriptor builder = new ValueDescriptor();
        builder.setName("Heap Fragmentation");
        builder.setDataType(DataType.DOUBLE);
        builder.setContentType("percentage");
        builder.setDescription("Percentage of the heap that is fragmented and not available for allocation.");
        builder.setIdentifier("fragmentationPercentage");
        return new Retriever(builder, fragmented.getEventTypePath()){

            public Object getValue(IEvent event) {
                return RetriverToolkit.divide(fragmented.getValue(event), used.getValue(event));
            }
        };
    }
}

