/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.api.RetriverToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitGlobalRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrack;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.IEventParserHook;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRThread;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;

public class GCExtension
implements IEventParserHook {
    private static final String BEFORE_HEAP_USAGE = "before:heapUsage";
    private static final String AFTER_HEAP_USAGE = "after:heapUsage";
    private static final String BEFORE_HEAP_SIZE = "before:heapSize";
    private static final String AFTER_HEAP_SIZE = "after:heapSize";
    private static final String GC_TYPE = "type";
    private static final FLRThread OC_THREAD = GCExtension.createThread(-12345, "[OC Thread]");
    private static final FLRThread YC_THREAD = GCExtension.createThread(-54321, "[Current YC Thread]");
    private final IRetriever m_usageBefore;
    private final IRetriever m_usageAfter;
    private final IRetriever m_beforeSize;
    private final IRetriever m_afterSize;
    private final IRetriever m_typeRetriever;
    private final EventTypeDescriptor m_gcDescriptor;
    private final EventTypeDescriptor m_heapUSageDescriptor;
    private final EventTypeDescriptor m_liveSetDescriptor;

    private GCExtension(EventTypeDescriptor gcDescriptor, EventTypeDescriptor heapUsageDescriptor, EventTypeDescriptor liveSetDescriptor, IRetriever before, IRetriever after, IRetriever beforeSize, IRetriever afterSize, IRetriever typeRetriever) {
        this.m_usageBefore = before;
        this.m_usageAfter = after;
        this.m_beforeSize = beforeSize;
        this.m_afterSize = afterSize;
        this.m_typeRetriever = typeRetriever;
        this.m_gcDescriptor = gcDescriptor;
        this.m_heapUSageDescriptor = heapUsageDescriptor;
        this.m_liveSetDescriptor = liveSetDescriptor;
    }

    private static FLRThread createThread(int i, String name) {
        FLRThread t = new FLRThread();
        t.setTrackIdentifier(i);
        t.setPlatformId(i);
        t.setName(name);
        return t;
    }

    public boolean execute(Event event, Environment environment, ITrackRepository trackRepository) {
        JRockitGlobalRepository jg = (JRockitGlobalRepository)trackRepository;
        this.addHeapUsageEvent(event, jg);
        if ("Old Collection".equals(this.m_typeRetriever.getValue(event))) {
            this.addLiveSetEvent(event, jg);
            this.addGCEvent(jg, event, OC_THREAD);
        } else {
            this.addGCEvent(jg, event, YC_THREAD);
        }
        return false;
    }

    private void addLiveSetEvent(Event event, JRockitGlobalRepository jg) {
        OptimizedEventType liveSetType = this.m_liveSetDescriptor.getEventType();
        JRockitTrack liveSetTrack = jg.getTrack(liveSetType);
        liveSetTrack.addEvent(this.createEvent(liveSetType, event.getEndTimestamp(), this.m_usageAfter.getValue(event), this.calcPercentage(event)));
        this.m_liveSetDescriptor.increaseCount();
    }

    private void addHeapUsageEvent(Event event, JRockitGlobalRepository jg) {
        OptimizedEventType heapUsageType = this.m_heapUSageDescriptor.getEventType();
        JRockitTrack heapUsagetrack = jg.getTrack(heapUsageType);
        heapUsagetrack.addEvent(this.createEvent(heapUsageType, event.getStartTimestamp(), this.m_usageBefore.getValue(event), this.m_beforeSize.getValue(event)));
        heapUsagetrack.addEvent(this.createEvent(heapUsageType, event.getEndTimestamp(), this.m_usageAfter.getValue(event), this.m_afterSize.getValue(event)));
        this.m_heapUSageDescriptor.increaseCount();
    }

    void addGCEvent(JRockitGlobalRepository trackrepository, Event event, FLRThread thread) {
        OptimizedEventType oet = (OptimizedEventType)event.getEventType();
        JRockitTrack track = trackrepository.lookupTrack(oet.getId(), thread.getTrackIdentifier());
        if (track == null) {
            track = trackrepository.addTrack(oet, thread);
            oet.addTrack(track);
        }
        track.addEvent(event);
        this.m_gcDescriptor.increaseCount();
    }

    private Object calcPercentage(IEvent event) {
        return RetriverToolkit.divide(this.m_usageAfter.getValue(event), this.m_afterSize.getValue(event));
    }

    private IEvent createEvent(IEventType type, long timeStamp, Object ... values) {
        return new Event(type, timeStamp, timeStamp, values);
    }

    public static void extend(Environment environment, Producer producer) {
        if (producer.getId() == 1) {
            EventTypeDescriptor gcDescriptor;
            EventTypeDescriptor heapUsageDescriptor = environment.getEventTypeDescriptor(3978);
            EventTypeDescriptor liveSetDescriptor = environment.getEventTypeDescriptor(3979);
            if ((heapUsageDescriptor.getEventType() == null || liveSetDescriptor.getEventType() == null) && (gcDescriptor = environment.findFirstEventTypeDescriptor("vm/gc/garbage_collection")) != null) {
                OptimizedEventType gcEventType = gcDescriptor.getEventType();
                IRetriever afterUsage = gcEventType.getRetriever(AFTER_HEAP_USAGE);
                IRetriever beforeUsage = gcEventType.getRetriever(BEFORE_HEAP_USAGE);
                IRetriever afterSize = gcEventType.getRetriever(AFTER_HEAP_SIZE);
                IRetriever beforeSize = gcEventType.getRetriever(BEFORE_HEAP_SIZE);
                IRetriever gcType = gcEventType.getRetriever(GC_TYPE);
                if (gcType != null && afterUsage != null && beforeUsage != null && beforeSize != null && afterSize != null) {
                    GCExtension.createHeapUsageEventType(producer, heapUsageDescriptor);
                    GCExtension.createLiveSetEventType(producer, liveSetDescriptor);
                    gcDescriptor.setEventParserHook(new GCExtension(gcDescriptor, heapUsageDescriptor, liveSetDescriptor, beforeUsage, afterUsage, beforeSize, afterSize, gcType));
                }
            }
        }
    }

    private static void createLiveSetEventType(Producer producer, EventTypeDescriptor etd) {
        etd.setDescription("The amount of memory on the heap after a full garbage collection, includes fragmentation.");
        etd.setName("Live Set");
        etd.setPath("vm/gc/live_set");
        etd.setHasThread(false);
        etd.setCanhavestacktrace(false);
        etd.setIsRequestable(false);
        etd.setHasStartTime(false);
        ValueDescriptor[] descriptors = new ValueDescriptor[2];
        descriptors[0] = new ValueDescriptor();
        descriptors[0].setDataType(DataType.LONG);
        descriptors[0].setName("Live Set");
        descriptors[0].setDescription("The amount of memory on the heap after a full garbage collection, includes fragmentation.");
        descriptors[0].setIdentifier("liveSet");
        descriptors[0].setContentType(UnitLookup.MEMORY.getIdentifier());
        descriptors[0].setRelationalKey("");
        descriptors[0].setDescription("");
        descriptors[1] = new ValueDescriptor();
        descriptors[1].setDataType(DataType.LONG);
        descriptors[1].setName("Live Set Percentage");
        descriptors[1].setDescription("The percentage of the heap that belongs to the live set.");
        descriptors[1].setIdentifier("liveSetPercentage");
        descriptors[1].setContentType(UnitLookup.PERCENTAGE.getIdentifier());
        descriptors[1].setRelationalKey("");
        descriptors[1].setDescription("");
        etd.setValueDescriptors(descriptors);
        OptimizedEventType type = OptimizedEventType.create(producer, etd);
        producer.addEventType(type);
        etd.setEventType(type);
    }

    private static void createHeapUsageEventType(Producer producer, EventTypeDescriptor etd) {
        etd.setDescription("Java Heap Usage");
        etd.setName("Heap Usage");
        etd.setPath("vm/gc/heap_usage");
        etd.setHasThread(false);
        etd.setCanhavestacktrace(false);
        etd.setIsRequestable(false);
        etd.setHasStartTime(false);
        ValueDescriptor[] descriptors = new ValueDescriptor[2];
        descriptors[0] = new ValueDescriptor();
        descriptors[0].setDataType(DataType.LONG);
        descriptors[0].setName("Heap Usage");
        descriptors[0].setDescription("The amount of memory used for Java objects.");
        descriptors[0].setIdentifier("heapUsage");
        descriptors[0].setContentType(UnitLookup.MEMORY.getIdentifier());
        descriptors[0].setRelationalKey("");
        descriptors[0].setDescription("");
        descriptors[1] = new ValueDescriptor();
        descriptors[1].setDataType(DataType.LONG);
        descriptors[1].setName("Heap Size");
        descriptors[1].setDescription("The amount of memory currently used for the size of the heap.");
        descriptors[1].setIdentifier("heapSize");
        descriptors[1].setContentType(UnitLookup.MEMORY.getIdentifier());
        descriptors[1].setRelationalKey("");
        descriptors[1].setDescription("");
        etd.setValueDescriptors(descriptors);
        OptimizedEventType type = OptimizedEventType.create(producer, etd);
        producer.addEventType(type);
        etd.setEventType(type);
    }
}

