/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitGlobalRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrack;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ArrayToEventFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.IEventParserHook;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;

class ArrayToEventHook
implements IEventParserHook {
    private final ArrayToEventFactory m_factory;
    private final int m_arrayIndex;
    private final int m_eventTypeIndex;

    public ArrayToEventHook(ArrayToEventFactory factory, int index, int eventTypeId) {
        this.m_arrayIndex = index;
        this.m_eventTypeIndex = eventTypeId;
        this.m_factory = factory;
    }

    public boolean execute(Event e, Environment environment, ITrackRepository trackRepository) {
        Object attributeArray = e.getAttributeValue(this.m_arrayIndex);
        if (attributeArray instanceof Object[]) {
            Object[] objectArray = (Object[])attributeArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Object[]) {
                    JRockitGlobalRepository jg = (JRockitGlobalRepository)trackRepository;
                    JRockitTrack track = jg.lookupTrack(this.m_eventTypeIndex, -1);
                    OptimizedEventType type = environment.getEventTypeDescriptor(this.m_eventTypeIndex).getEventType();
                    if (track == null) {
                        track = jg.addTrack(type, null);
                        type.addTrack(track);
                    }
                    track.addEvent(this.m_factory.createEvent(type, e.getStartTimestamp(), e.getEndTimestamp(), (Object[])o));
                }
                ++n2;
            }
        }
        return false;
    }
}

