/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptorToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ArrayToEventHook;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.CompositeEventParserHook;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.IEventParserHook;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayToEventFactory {
    private final Environment m_environment;
    private String[] m_sourceAttribute;
    private EventTypeDescriptor[] m_targetEventTypeDescriptors;
    private String m_sourceTypePath;
    private boolean m_removeSourceType;

    public ArrayToEventFactory(Environment environment) {
        this.m_environment = environment;
    }

    protected final Environment getEnviroment() {
        return this.m_environment;
    }

    protected IEvent createEvent(OptimizedEventType type, long startTimestamp, long endTimestamp, Object[] values) {
        return new Event(type, startTimestamp, endTimestamp, values);
    }

    public void setRemoveSourceType(boolean removeSourceType) {
        this.m_removeSourceType = removeSourceType;
    }

    public void setSourceAttributes(String ... attributes) {
        this.m_sourceAttribute = attributes;
    }

    public void setSourceTypePath(String typePath) {
        this.m_sourceTypePath = typePath;
    }

    private boolean isNotHooked(EventTypeDescriptor destinationDescriptor) {
        return destinationDescriptor != null && destinationDescriptor.getEventParserHook() == null;
    }

    public void createEventType(Producer producer) {
        EventTypeDescriptor destinationDescriptor;
        if (producer.getId() == 1 && this.isNotHooked(destinationDescriptor = this.m_environment.findFirstEventTypeDescriptor(this.m_sourceTypePath))) {
            this.installHooks(producer, destinationDescriptor);
        }
    }

    private void installHooks(Producer producer, EventTypeDescriptor destinationDescriptor) {
        ValueDescriptor[] arrayDescriptor = destinationDescriptor.getValueDescriptors();
        ArrayList<IEventParserHook> hooks = new ArrayList<IEventParserHook>();
        int n = 0;
        while (n < this.m_sourceAttribute.length) {
            int attributeIndex = ValueDescriptorToolkit.getIndex(arrayDescriptor, this.m_sourceAttribute[n]);
            if (attributeIndex != -1) {
                ValueDescriptor[] descriptors = arrayDescriptor[attributeIndex].getChildren();
                this.m_targetEventTypeDescriptors[n].setValueDescriptors(this.createValueDescriptors(this.m_sourceAttribute[n], descriptors));
                OptimizedEventType type = OptimizedEventType.create(producer, this.m_targetEventTypeDescriptors[n]);
                producer.addEventType(type);
                this.m_targetEventTypeDescriptors[n].setEventType(type);
                this.m_environment.addEventTypeDescriptor(this.m_targetEventTypeDescriptors[n]);
                hooks.add(new ArrayToEventHook(this, attributeIndex, this.m_targetEventTypeDescriptors[n].getIdentifier()));
            }
            ++n;
        }
        IEventParserHook hook = this.createHook(hooks);
        if (hook != null) {
            destinationDescriptor.setHidden(this.m_removeSourceType);
            destinationDescriptor.setEventParserHook(this.createHook(hooks));
        }
    }

    private IEventParserHook createHook(List<IEventParserHook> hooks) {
        if (hooks.isEmpty()) {
            return null;
        }
        if (hooks.size() == 1) {
            return hooks.get(0);
        }
        return new CompositeEventParserHook(hooks.toArray(new IEventParserHook[hooks.size()]));
    }

    protected ValueDescriptor[] createValueDescriptors(String sourceAttribute, ValueDescriptor[] descriptors) {
        return descriptors;
    }

    public void setTargetEventTypeDescriptors(EventTypeDescriptor ... typeDescriptors) {
        this.m_targetEventTypeDescriptors = typeDescriptors;
    }
}

