/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.Retriever;
import com.jrockit.mc.flightrecorder.api.RetriverToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRetriever;

public final class AllocatedByAllThreadsExtension {
    public static void extend(IEventType type) {
        if (type.getPath().equals("java/statistics/alloc_total")) {
            IRetriever insideTLA = type.getRetriever("allocated:insideTla");
            IRetriever outsideTLA = type.getRetriever("allocated:outsideTla");
            if (insideTLA != null && outsideTLA != null) {
                type.addRetriever(AllocatedByAllThreadsExtension.createRetriever(insideTLA, outsideTLA));
            }
        }
    }

    private static IRetriever createRetriever(final IRetriever insideTLA, final IRetriever outsideTLA) {
        ValueDescriptor builder = new ValueDescriptor();
        builder.setName("Total Allocated");
        builder.setDataType(DataType.LONG);
        builder.setContentType(UnitLookup.MEMORY.getIdentifier());
        builder.setDescription("Total Allocated by all threads");
        builder.setIdentifier("totalAllocated");
        return new Retriever(builder, insideTLA.getEventTypePath()){

            public Object getValue(IEvent event) {
                return RetriverToolkit.add(insideTLA.getValue(event), outsideTLA.getValue(event));
            }
        };
    }
}

