/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptorToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ArrayToEventFactory;
import com.jrockit.mc.flightrecorder.spi.IEvent;

public final class ActiveRecordingEventFactory
extends ArrayToEventFactory {
    private int m_eventTypeAttributeIndex;
    private int m_thresholdAttributeIndex;
    private int m_periodAttributeIndex;
    private int m_stacktraceEnabledAttributeIndex;

    public ActiveRecordingEventFactory(Environment environment, String sourceTypePath) {
        super(environment);
        this.setSourceAttributes("settings", "recordings");
        this.setSourceTypePath(sourceTypePath);
        this.setTargetEventTypeDescriptors(this.createSettingDescriptor(), this.createRecordingDescriptor());
        this.setRemoveSourceType(true);
    }

    private EventTypeDescriptor createSettingDescriptor() {
        EventTypeDescriptor type = new EventTypeDescriptor(3982);
        type.setName("Recording Setting");
        type.setDescription("Setting used for all ongoing/active flight recordings.");
        type.setPath("recordings/recording_setting");
        return type;
    }

    private EventTypeDescriptor createRecordingDescriptor() {
        EventTypeDescriptor type = new EventTypeDescriptor(3984);
        type.setName("Flight Recording");
        type.setDescription("Information about an ongoing/active flight recording.");
        type.setPath("recordings/recording");
        return type;
    }

    protected IEvent createEvent(OptimizedEventType type, long startTimestamp, long endTimestamp, Object[] values) {
        if (type.getId() == 3982) {
            this.patchSettingsValues(values, this.getEnviroment());
        }
        return new Event(type, startTimestamp, endTimestamp, values);
    }

    private Object[] patchSettingsValues(Object[] array, Environment e) {
        Long l;
        if (array.length > this.m_eventTypeAttributeIndex && array[this.m_eventTypeAttributeIndex] instanceof Integer) {
            Integer integer = (Integer)array[this.m_eventTypeAttributeIndex];
            EventTypeDescriptor etd = e.getEventTypeDescriptor(integer);
            array[this.m_eventTypeAttributeIndex] = etd.getEventType();
        }
        if (array.length > this.m_thresholdAttributeIndex && array[this.m_thresholdAttributeIndex] instanceof Long) {
            l = (long)((Long)array[this.m_thresholdAttributeIndex]);
            array[this.m_thresholdAttributeIndex] = l == -1L ? Long.MIN_VALUE : l;
        }
        if (array.length > this.m_periodAttributeIndex && array[this.m_periodAttributeIndex] instanceof Long) {
            l = (long)((Long)array[this.m_periodAttributeIndex]);
            array[this.m_periodAttributeIndex] = l == 0L ? Long.MIN_VALUE : 1000000L * l;
        }
        return array;
    }

    protected ValueDescriptor[] createValueDescriptors(String attribute, ValueDescriptor[] descriptors) {
        if ("settings".equals(attribute)) {
            ValueDescriptor copy;
            ValueDescriptor[] vds = (ValueDescriptor[])descriptors.clone();
            this.m_eventTypeAttributeIndex = ValueDescriptorToolkit.getIndex(descriptors, "id");
            if (this.isValidDescriptorIndex(this.m_eventTypeAttributeIndex)) {
                copy = this.createCopy(descriptors[this.m_eventTypeAttributeIndex]);
                copy.setDataType(DataType.STRING);
                copy.setContentType(UnitLookup.PLAIN_TEXT.getIdentifier());
                copy.setName("Event Type");
                copy.setDescription("");
                copy.setIdentifier("eventSetting");
                vds[this.m_eventTypeAttributeIndex] = copy;
            }
            this.m_stacktraceEnabledAttributeIndex = ValueDescriptorToolkit.getIndex(descriptors, "stacktrace");
            if (this.isValidDescriptorIndex(this.m_stacktraceEnabledAttributeIndex)) {
                copy = this.createCopy(descriptors[this.m_stacktraceEnabledAttributeIndex]);
                copy.setIdentifier("stackTraceEnabled");
                copy.setContentType(UnitLookup.PLAIN_TEXT.getIdentifier());
                vds[this.m_stacktraceEnabledAttributeIndex] = copy;
            }
            this.m_thresholdAttributeIndex = ValueDescriptorToolkit.getIndex(descriptors, "threshold");
            if (this.isValidDescriptorIndex(this.m_thresholdAttributeIndex)) {
                copy = this.createCopy(descriptors[this.m_thresholdAttributeIndex]);
                copy.setContentType(UnitLookup.TIMESPAN.getIdentifier());
                vds[this.m_thresholdAttributeIndex] = copy;
            }
            this.m_periodAttributeIndex = ValueDescriptorToolkit.getIndex(descriptors, "period");
            if (this.isValidDescriptorIndex(this.m_periodAttributeIndex)) {
                copy = this.createCopy(descriptors[this.m_periodAttributeIndex]);
                copy.setContentType(UnitLookup.TIMESPAN.getIdentifier());
                vds[this.m_periodAttributeIndex] = copy;
            }
            return vds;
        }
        return descriptors;
    }

    private boolean isValidDescriptorIndex(int index) {
        return index >= 0;
    }

    private ValueDescriptor createCopy(ValueDescriptor valueDescriptor) {
        return (ValueDescriptor)valueDescriptor.clone();
    }
}

