/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Transition;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.DataTypeParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.TransitionParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.Synthetics;

final class ValueDescriptorParser
implements IParser {
    private final UTFStringParser IDENTIFIER = new UTFStringParser();
    private final UTFStringParser NAME = new UTFStringParser();
    private final UTFStringParser DESCRIPTION = new UTFStringParser();
    private final DataTypeParser DATATYPE = new DataTypeParser();
    private final IntegerParser CONSTANT_POOL_INDEX = new IntegerParser();
    private final IntegerParser DATA_STRUCTURE_IDENTIFIER = new IntegerParser();
    private final IntegerParser EXPANSION = new IntegerParser();
    private final TransitionParser TRANSITION = new TransitionParser();
    private int m_size;

    ValueDescriptorParser() {
    }

    public int getSize() {
        return this.m_size;
    }

    public ValueDescriptor read(byte[] data, int offset) {
        int index = offset;
        String id = this.IDENTIFIER.read(data, index);
        String name = this.NAME.read(data, index += this.IDENTIFIER.getSize());
        String description = this.DESCRIPTION.read(data, index += this.NAME.getSize());
        Transition transition = this.TRANSITION.read(data, index += this.DESCRIPTION.getSize());
        DataType dataType = this.DATATYPE.read(data, index += this.TRANSITION.getSize());
        int constantPoolindex = this.CONSTANT_POOL_INDEX.read(data, index += this.DATATYPE.getSize());
        int dataStructureIndex = this.DATA_STRUCTURE_IDENTIFIER.read(data, index += this.CONSTANT_POOL_INDEX.getSize());
        this.EXPANSION.read(data, index += this.DATA_STRUCTURE_IDENTIFIER.getSize());
        this.m_size = (index += this.EXPANSION.getSize()) - offset;
        ValueDescriptor vd = new ValueDescriptor();
        vd.setDataType(dataType);
        vd.setIdentifier(id);
        vd.setName(name);
        vd.setDescription(description);
        vd.setTransition(transition);
        vd.setConstantPoolIndex(constantPoolindex);
        vd.setDataStructureIndex(dataStructureIndex);
        vd.setRelationIndex(Synthetics.deduceRelationIndex(dataType, dataStructureIndex));
        vd.setContentType(Synthetics.createContentType(vd));
        vd.setFactor(Synthetics.deduceFactor(constantPoolindex));
        return vd;
    }
}

