/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ShortParser;
import java.io.UnsupportedEncodingException;

final class UTFStringParser
implements IParser {
    private final byte[] m_byteCache = new byte[256];
    private int m_byteCacheLength = -1;
    private String m_lastString;
    private int m_size;

    UTFStringParser() {
    }

    public int getSize() {
        return this.m_size;
    }

    public String read(byte[] data, int index) {
        short len = ShortParser.readShort(data, index);
        this.m_size = 2 + len;
        if (!this.equalsByteCache(data, index + 2, len)) {
            String result;
            try {
                result = new String(data, index + 2, (int)len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "<unsupportedEncoding>";
            }
            if (this.storeByteCache(data, index, len)) {
                this.m_lastString = result;
            } else {
                return result;
            }
        }
        return this.m_lastString;
    }

    private boolean equalsByteCache(byte[] bytes, int index, short len) {
        if (this.m_byteCacheLength != len) {
            return false;
        }
        if (len >= this.m_byteCache.length) {
            return false;
        }
        int n = 0;
        while (n < len) {
            if (this.m_byteCache[n] != bytes[index + n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean storeByteCache(byte[] bytes, int index, int len) {
        if (len >= this.m_byteCache.length) {
            return false;
        }
        int n = 0;
        while (n < len) {
            this.m_byteCache[n] = bytes[index + n];
            ++n;
        }
        this.m_byteCacheLength = len;
        return true;
    }
}

