/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.TimeLocale;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;

final class TimeStampParser
implements IParser {
    public static final int SIZE = 8;
    private final long m_startNanos;
    private final long m_startTick;
    private final double m_divider;

    private static AdjustedParserValues adjustTimeLocale(TimeLocale timeLocale, TimeStampParser previousParser) {
        long previousMillis;
        if (previousParser == null) {
            return new AdjustedParserValues(timeLocale);
        }
        long localeMillis = TimeStampParser.getStartMillis(timeLocale);
        if (localeMillis > (previousMillis = previousParser.asMillis(0L))) {
            return new AdjustedParserValues(timeLocale);
        }
        return new AdjustedParserValues(previousParser);
    }

    private static long getStartMillis(TimeLocale timeLocale) {
        return timeLocale.getStartTimeMillis1970() - timeLocale.getStartTicks() * 1000L / timeLocale.getTicksPerSecond();
    }

    TimeStampParser(TimeLocale timeLocale, TimeStampParser previousParser) {
        AdjustedParserValues adjustedValues = TimeStampParser.adjustTimeLocale(timeLocale, previousParser);
        this.m_startTick = adjustedValues.m_startTick;
        this.m_startNanos = adjustedValues.m_startNanos;
        this.m_divider = adjustedValues.m_divider;
    }

    public int getSize() {
        return 8;
    }

    public Long read(byte[] data, int offset) {
        return this.readTimeStamp(data, offset);
    }

    private long asMillis(long ticks) {
        return this.m_startNanos + (long)((double)(ticks - this.m_startTick) / this.m_divider);
    }

    public long readTimeStamp(byte[] data, int offset) {
        return this.asMillis(LongParser.readLong(data, offset));
    }

    private static class AdjustedParserValues {
        private final long m_startNanos;
        private final long m_startTick;
        private final double m_divider;

        public AdjustedParserValues(TimeLocale timeLocale) {
            this.m_startNanos = timeLocale.getStartTimeMillis1970() * 1000L * 1000L;
            this.m_startTick = timeLocale.getStartTicks();
            this.m_divider = (double)timeLocale.getTicksPerSecond() / 1.0E9;
        }

        public AdjustedParserValues(TimeStampParser parser) {
            this.m_startNanos = parser.m_startNanos;
            this.m_startTick = parser.m_startTick;
            this.m_divider = parser.m_divider;
        }
    }
}

