/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.TimeLocale;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.UTFStringParser;

final class TimeLocaleParser
implements IParser {
    private final UTFStringParser LOCALE_PARSER = new UTFStringParser();
    private int m_size;

    TimeLocaleParser() {
    }

    public int getSize() {
        return this.m_size;
    }

    public TimeLocale read(byte[] data, int offset) {
        int index = offset;
        long start = LongParser.readLong(data, index);
        long end = LongParser.readLong(data, index += 8);
        long startTicks = LongParser.readLong(data, index += 8);
        long ticksPerSecond = LongParser.readLong(data, index += 8);
        long previousCheckPoint = LongParser.readLong(data, index += 8);
        String locale = this.LOCALE_PARSER.read(data, index += 8);
        int gmtOffset = IntegerParser.readInt(data, index += this.LOCALE_PARSER.getSize());
        index += 4;
        TimeLocale timeInformation = new TimeLocale();
        timeInformation.setStartTimeMillis1970(start);
        timeInformation.setEndTimeMillis1970(end);
        timeInformation.setStartTicks(startTicks);
        timeInformation.setTicksPerSecond(ticksPerSecond);
        timeInformation.setLocale(locale);
        timeInformation.setGMTOffset(gmtOffset);
        timeInformation.setPreviousCheckPoint((int)previousCheckPoint);
        this.m_size = index - offset;
        return timeInformation;
    }
}

