/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataStructure;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ArrayParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ConstantPoolDescriptorParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ConstantPoolKeyParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.DataStructureParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.EventTypeParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ParserFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ActiveRecordingEventFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.AllocatedByAllThreadsExtension;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.GCExtension;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.HeapFragmentationExtension;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.InitialEnvironmentVariableEventFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.InitialSystemPropertyEventFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.InitialTimedEventRemover;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ProcessEventFactory;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.Synthetics;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.ThreadLifetimeHook;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProducerParser
implements IParser {
    private final IntegerParser IDENTIFIER_PARSER = new IntegerParser();
    private final UTFStringParser NAME_PARSER = new UTFStringParser();
    private final UTFStringParser DESCRIPTION_PARSER = new UTFStringParser();
    private final UTFStringParser URI_PARSER = new UTFStringParser();
    private final ArrayParser RELATIONS_PARSER = new ArrayParser(new UTFStringParser());
    private final ArrayParser DATASTRUCTURES_PARSER = new ArrayParser(new DataStructureParser());
    private final ArrayParser EVENT_TYPES_PARSER;
    private final ArrayParser CONSTANT_POOL_PARSER = new ArrayParser(new ConstantPoolDescriptorParser());
    private final InitialSystemPropertyEventFactory INITIAL_SYSTEM_PROPERTY_EXTENSION;
    private final InitialEnvironmentVariableEventFactory INITIAL_ENVIRONMENT_VARIABLE;
    private final ProcessEventFactory PROCESS_EVENT_EXTENSION;
    private final ActiveRecordingEventFactory ACTIVE_SETTING_EVENT_FACTORY;
    private final Environment m_environment;
    private final ParserFactory m_parserFactory;
    private int m_size;
    private ActiveRecordingEventFactory SETTING_CHANGED_EVENT_FACTORY;

    ProducerParser(Environment environment) {
        this.m_environment = environment;
        this.m_parserFactory = new ParserFactory(this.m_environment);
        this.EVENT_TYPES_PARSER = new ArrayParser(new EventTypeParser());
        this.INITIAL_SYSTEM_PROPERTY_EXTENSION = new InitialSystemPropertyEventFactory(this.m_environment);
        this.INITIAL_ENVIRONMENT_VARIABLE = new InitialEnvironmentVariableEventFactory(this.m_environment);
        this.PROCESS_EVENT_EXTENSION = new ProcessEventFactory(this.m_environment);
        this.ACTIVE_SETTING_EVENT_FACTORY = new ActiveRecordingEventFactory(this.m_environment, "recordings/active");
        this.SETTING_CHANGED_EVENT_FACTORY = new ActiveRecordingEventFactory(this.m_environment, "recordings/settingsChanged");
    }

    @Override
    public int getSize() {
        return this.m_size;
    }

    @Override
    public IProducer read(byte[] data, int offset) {
        int index = offset;
        int pid = this.IDENTIFIER_PARSER.read(data, index);
        String producerName = this.NAME_PARSER.read(data, index += this.IDENTIFIER_PARSER.getSize());
        String producerDescription = this.DESCRIPTION_PARSER.read(data, index += this.NAME_PARSER.getSize());
        String producerURI = this.URI_PARSER.read(data, index += this.DESCRIPTION_PARSER.getSize());
        final Object[] relations = this.RELATIONS_PARSER.read(data, index += this.URI_PARSER.getSize());
        final Object[] dataStructures = this.DATASTRUCTURES_PARSER.read(data, index += this.RELATIONS_PARSER.getSize());
        final Object[] eventTypes = this.EVENT_TYPES_PARSER.read(data, index += this.DATASTRUCTURES_PARSER.getSize());
        Object[] constantPools = this.CONSTANT_POOL_PARSER.read(data, index += this.EVENT_TYPES_PARSER.getSize());
        index += this.CONSTANT_POOL_PARSER.getSize();
        final Producer producer = this.m_environment.getProducer(pid);
        producer.setName(producerName);
        producer.setDescription(producerDescription);
        producer.setURIString(producerURI);
        producer.setNamespace("" + pid);
        producer.setRelations(this.createRelationList(relations));
        this.initializeDataStructures(dataStructures);
        this.initializeConstantPools(constantPools, dataStructures);
        producer.setInitializationCallback(new Runnable(){

            public void run() {
                ProducerParser.this.initializeEventTypes(producer, eventTypes, relations, dataStructures);
            }
        });
        this.m_size = index - offset;
        return producer;
    }

    private void initializeConstantPools(Object[] constantPools, Object[] dataStructures) {
        ConstantPool pool;
        Object cp;
        Object[] objectArray = constantPools;
        int n = constantPools.length;
        int n2 = 0;
        while (n2 < n) {
            cp = objectArray[n2];
            pool = (ConstantPool)cp;
            this.m_environment.addConstantPool(pool);
            int index = pool.getStructIndex();
            DataStructure ds = (DataStructure)dataStructures[index];
            pool.setValueDescriptors(ds.getValueDescriptors());
            ++n2;
        }
        objectArray = constantPools;
        n = constantPools.length;
        n2 = 0;
        while (n2 < n) {
            cp = objectArray[n2];
            pool = (ConstantPool)cp;
            pool.setValueParser(this.m_parserFactory.createParser(pool.getValueDescriptors(), false));
            pool.setKeyParser(new ConstantPoolKeyParser(pool.getDataType()));
            pool.setFactory(this.m_environment.getFactory(pool));
            ++n2;
        }
    }

    private void initializeEventTypes(Producer producer, Object[] eventTypes, Object[] relations, Object[] dataStructures) {
        int n = 0;
        while (n < eventTypes.length) {
            EventTypeDescriptor etdObject = (EventTypeDescriptor)eventTypes[n];
            EventTypeDescriptor etd = this.m_environment.addEventTypeDescriptor(etdObject);
            if (etd.getEventType() == null) {
                DataStructure ds = (DataStructure)dataStructures[etdObject.getChildType()];
                ValueDescriptor[] topDescriptors = this.createTopDescriptors(etd, ds);
                ValueDescriptor[] exploded = this.createExploded(topDescriptors);
                this.addRelationsStrings(relations, topDescriptors);
                etd.setValueDescriptors(topDescriptors);
                etd.setParsers(this.m_parserFactory.createParsers(exploded, true));
                OptimizedEventType oe = OptimizedEventType.create(producer, etd);
                etd.setEventType(oe);
                HeapFragmentationExtension.extend(oe);
                AllocatedByAllThreadsExtension.extend(oe);
                producer.addEventType(oe);
            }
            ++n;
        }
        this.INITIAL_SYSTEM_PROPERTY_EXTENSION.createEventType(producer);
        this.INITIAL_ENVIRONMENT_VARIABLE.createEventType(producer);
        this.PROCESS_EVENT_EXTENSION.createEventType(producer);
        this.ACTIVE_SETTING_EVENT_FACTORY.createEventType(producer);
        this.SETTING_CHANGED_EVENT_FACTORY.createEventType(producer);
        GCExtension.extend(this.m_environment, producer);
        Synthetics.createBufferLostEventType(producer, this.m_environment);
        InitialTimedEventRemover.install(this.m_environment, producer, "java/statistics/lock_profile", 1000000000L);
        InitialTimedEventRemover.install(this.m_environment, producer, "vm/sync/lock_profile", 1000000000L);
        ThreadLifetimeHook.install(this.m_environment, producer, "java/thread_start", true);
        ThreadLifetimeHook.install(this.m_environment, producer, "java/thread_end", false);
    }

    private void addRelationsStrings(Object[] relations, ValueDescriptor[] valueDescriptors) {
        ValueDescriptor[] valueDescriptorArray = valueDescriptors;
        int n = valueDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ValueDescriptor vd = valueDescriptorArray[n2];
            int index = vd.getRelationIndex();
            if (index >= 0) {
                String name = (String)relations[index];
                vd.setRelationalKey(name);
                this.addRelationsStrings(relations, vd.getChildren());
            }
            ++n2;
        }
    }

    private ValueDescriptor[] createExploded(ValueDescriptor[] descriptors) {
        ArrayList<ValueDescriptor> exploded = new ArrayList<ValueDescriptor>();
        ValueDescriptor[] valueDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ValueDescriptor d = valueDescriptorArray[n2];
            exploded.addAll(this.explode(d));
            ++n2;
        }
        return exploded.toArray(new ValueDescriptor[exploded.size()]);
    }

    private ValueDescriptor[] createTopDescriptors(EventTypeDescriptor etd, DataStructure ds) {
        ArrayList<ValueDescriptor> top = new ArrayList<ValueDescriptor>();
        top.addAll(Synthetics.createSyntheticDescriptors(etd));
        top.addAll((Collection)Arrays.asList(ds.getValueDescriptors()));
        return top.toArray(new ValueDescriptor[top.size()]);
    }

    List<ValueDescriptor> explode(ValueDescriptor vd) {
        ArrayList<ValueDescriptor> exploded = new ArrayList<ValueDescriptor>();
        if (vd.getDataType() == DataType.STRUCT) {
            ValueDescriptor[] children = vd.getChildren();
            int n = 0;
            while (n < children.length) {
                exploded.addAll(this.explode(children[n]));
                ++n;
            }
        } else {
            exploded.add(vd);
        }
        return exploded;
    }

    private void initializeDataStructures(Object[] dataStructures) {
        int n = 0;
        while (n < dataStructures.length) {
            DataStructure ds = (DataStructure)dataStructures[n];
            ValueDescriptor[] vds = ds.getValueDescriptors();
            int m = 0;
            while (m < vds.length) {
                ValueDescriptor vd = vds[m];
                if (!vd.getDataType().isPrimitive()) {
                    int index = vd.getChildType();
                    DataStructure referenceStructure = (DataStructure)dataStructures[index];
                    vd.setChildren(referenceStructure.getValueDescriptors());
                }
                ++m;
            }
            ++n;
        }
    }

    private List<String> createRelationList(Object[] relations) {
        ArrayList<String> list = new ArrayList<String>();
        Object[] objectArray = relations;
        int n = relations.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            list.add((String)o);
            ++n2;
        }
        return list;
    }
}

