/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ArrayParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.BooleanParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ByteParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.CompositeParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.DoubleParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.FactorParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.FloatParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.FrameArrayParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.PoolReferenceParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.PoolValueParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ShortParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.StringParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.TimeSpanParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.UTFStringParser;

public final class ParserFactory {
    private final Environment m_environment;

    public ParserFactory(Environment environment) {
        this.m_environment = environment;
    }

    public IParser createParser(ValueDescriptor[] descriptors, boolean notPool) {
        if (descriptors.length == 1) {
            return this.createParser(descriptors[0], notPool);
        }
        return new CompositeParser(this.createParsers(descriptors, notPool));
    }

    public IParser[] createParsers(ValueDescriptor[] valueDescriptors, boolean notPool) {
        IParser[] parsers = new IParser[valueDescriptors.length];
        int n = 0;
        while (n < valueDescriptors.length) {
            parsers[n] = this.createParser(valueDescriptors[n], notPool);
            ++n;
        }
        return parsers;
    }

    private IParser createParser(ValueDescriptor vd, boolean poolValue) {
        ConstantPool pool = this.m_environment.getConstantPool(vd.getConstantPoolIndex());
        if (pool != null) {
            if (poolValue) {
                if (vd.getDataType() == DataType.ARRAY) {
                    return new ArrayParser(new PoolValueParser(pool));
                }
                return new PoolValueParser(pool);
            }
            if (vd.getDataType() == DataType.ARRAY) {
                return new ArrayParser(new PoolReferenceParser(pool));
            }
            return new PoolReferenceParser(pool);
        }
        if (vd.getConstantPoolIndex() == 5) {
            return new TimeSpanParser(this.createSimpleParser(vd, poolValue), this.m_environment);
        }
        if (DataType.STRUCTARRAY == vd.getDataType() && poolValue && "frames".equals(vd.getIdentifier())) {
            vd.setIdentifier("stacktrace");
            vd.setName("Stacktrace");
            vd.setContentType("stacktrace");
            return new FrameArrayParser(this.createSimpleParser(vd, poolValue), this.m_environment);
        }
        if (vd.getFactor() != null) {
            return new FactorParser(this.createSimpleParser(vd, poolValue), vd.getFactor());
        }
        return this.createSimpleParser(vd, poolValue);
    }

    private IParser createSimpleParser(ValueDescriptor vd, boolean poolValue) {
        DataType dataType = vd.getDataType();
        switch (dataType) {
            case BYTE: 
            case U1: {
                return new ByteParser();
            }
            case BOOLEAN: {
                return new BooleanParser();
            }
            case SHORT: 
            case U2: {
                return new ShortParser();
            }
            case INTEGER: 
            case U4: {
                return new IntegerParser();
            }
            case FLOAT: {
                return new FloatParser();
            }
            case LONG: 
            case U8: {
                return new LongParser();
            }
            case DOUBLE: {
                return new DoubleParser();
            }
            case STRING: {
                return new StringParser();
            }
            case UTF8: {
                return new UTFStringParser();
            }
            case ARRAY: 
            case STRUCTARRAY: {
                return new ArrayParser(this.createParser(vd.getChildren(), poolValue));
            }
            case STRUCT: {
                return this.createParser(vd.getChildren(), poolValue);
            }
        }
        throw new IllegalStateException("Can't parse datatype " + (Object)((Object)dataType));
    }
}

