/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.TimeLocale;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ArrayParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.CheckPointParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ProducerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.TimeLocaleParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetadataParser
implements IParser {
    private final ArrayParser PRODUCERS_PARSER;
    private final TimeLocaleParser TIMING_PARSER = new TimeLocaleParser();
    private final Environment m_environment;
    private int m_size;

    @Override
    public int getSize() {
        return this.m_size;
    }

    public MetadataParser(Environment environment) {
        this.m_environment = environment;
        this.PRODUCERS_PARSER = new ArrayParser(new ProducerParser(environment));
    }

    @Override
    public Object read(byte[] data, int offset) {
        int index = offset;
        Object[] producers = this.PRODUCERS_PARSER.read(data, index);
        index += this.PRODUCERS_PARSER.getSize();
        int n = 0;
        while (n < producers.length) {
            Producer p = (Producer)producers[n];
            p.getInitializationCallBack().run();
            ++n;
        }
        TimeLocale ti = this.TIMING_PARSER.read(data, index);
        index += this.TIMING_PARSER.getSize();
        this.m_environment.setTimeLocale(ti);
        List<Integer> checkPointsPositions = this.readCheckPoints(data, ti.getPreviousCheckPoint());
        index += 8;
        CheckPointParser cp = new CheckPointParser(this.m_environment);
        this.m_environment.resetCheckPoint();
        int cpCOunter = 0;
        for (int position : checkPointsPositions) {
            ++cpCOunter;
            cp.read(data, position);
            this.m_environment.nextCheckPoint();
        }
        this.m_size = index - offset;
        return producers;
    }

    private List<Integer> readCheckPoints(byte[] data, int offset) {
        int index = offset;
        ArrayList<Integer> constantPoolIndices = new ArrayList<Integer>();
        while (index != 0) {
            constantPoolIndices.add(index -= 16);
            index += 4;
            index += 4;
            index += 8;
            index = this.readLongAsInt(data, index);
        }
        Collections.reverse(constantPoolIndices);
        return constantPoolIndices;
    }

    private int readLongAsInt(byte[] data, int index) {
        return (int)LongParser.readLong(data, index);
    }
}

