/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.api.Event;
import com.jrockit.mc.flightrecorder.api.EventTypeRepository;
import com.jrockit.mc.flightrecorder.api.ProgressMonitor;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.SortedInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitGlobalRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrack;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.MetadataParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.TimeStampParser;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRThread;
import com.jrockit.mc.flightrecorder.spi.IEventTypeRepository;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import java.io.IOException;

public final class MainParser {
    private final IBinaryChunkInput m_input;
    private final Environment m_environment;
    private final JRockitGlobalRepository m_trackRepository;
    private final EventTypeRepository m_eventTypeRepository;
    int chunkCount = 0;
    private long m_startTime = 0x3FFFFFFFFFFFFFFFL;
    private long m_endTime = -4611686018427387904L;
    private TimeStampParser m_lastTimeStampParser = null;

    public MainParser(IBinaryChunkInput input) {
        this.m_input = input;
        this.m_environment = new Environment();
        this.m_trackRepository = new JRockitGlobalRepository();
        this.m_eventTypeRepository = new EventTypeRepository();
    }

    public void read(ProgressMonitor monitor) throws IOException {
        monitor.beginTask(1, "Starting reading events");
        while (true) {
            monitor.log(ProgressMonitor.SEVERITY.INFO, "Reading chunk", null);
            BinaryChunk ch = this.m_input.nextChunk();
            if (ch == null) break;
            monitor.log(ProgressMonitor.SEVERITY.INFO, "Parsing events", null);
            this.read(ch);
            ++this.chunkCount;
        }
        monitor.log(ProgressMonitor.SEVERITY.INFO, "Parsing events", null);
        monitor.endTask();
        for (EventTypeDescriptor etd : this.m_environment.getEventTypeDescriptors()) {
            OptimizedEventType type = etd.getEventType();
            if (type == null || etd.isHidden()) continue;
            this.m_eventTypeRepository.add(etd.getEventType());
        }
    }

    public ITrackRepository getTrackRepository() {
        return this.m_trackRepository;
    }

    public IEventTypeRepository getEventTypeRepository() {
        return this.m_eventTypeRepository;
    }

    void read(BinaryChunk bc) {
        MetadataParser metadataParser = new MetadataParser(this.m_environment);
        this.m_environment.setCheckPoint(0);
        this.m_environment.clearConstantPools();
        byte[] data = bc.getData();
        int offset = (int)bc.getDescriptor().getMetadataOffset();
        metadataParser.read(data, offset + 4 + 4);
        TimeStampParser timeStampParser = new TimeStampParser(this.m_environment.getTimeLocale(), this.m_lastTimeStampParser);
        this.m_environment.setCheckPoint(0);
        this.m_startTime = Math.min(this.m_environment.getTimeLocale().getStartTimeMillis1970() * 1000L * 1000L, this.m_startTime);
        this.m_endTime = Math.max(this.m_environment.getTimeLocale().getEndTimeMillis1970() * 1000L * 1000L, this.m_endTime);
        for (SortedInput.EventPosition p : bc.getDescriptor().getPositions()) {
            long startTime;
            int index = p.index;
            int eventTypeId = IntegerParser.readInt(data, index += 4);
            index += 4;
            EventTypeDescriptor etd = this.m_environment.getEventTypeDescriptor(eventTypeId);
            if (eventTypeId == 1) {
                this.fixJavaThreadPool();
                this.m_environment.nextCheckPoint();
            }
            if (!etd.accept()) continue;
            long endTime = timeStampParser.readTimeStamp(data, index);
            index += 8;
            if (etd.hasStartTime()) {
                startTime = timeStampParser.readTimeStamp(data, index);
                index += 8;
            } else {
                startTime = endTime;
            }
            IParser[] parsers = etd.getParsers();
            Object[] values = new Object[parsers.length];
            int n = 0;
            while (n < parsers.length) {
                values[n] = parsers[n].read(data, index);
                index += parsers[n].getSize();
                ++n;
            }
            OptimizedEventType oet = etd.getEventType();
            Event e = new Event(oet, startTime, endTime, values);
            if (etd.getEventParserHook() != null && !etd.getEventParserHook().execute(e, this.m_environment, this.m_trackRepository)) continue;
            FLRThread t = etd.hasThread() ? (FLRThread)values[0] : null;
            JRockitTrack track = this.m_trackRepository.lookupTrack(eventTypeId, this.getTrackIdentifier(t));
            if (track == null) {
                track = this.m_trackRepository.addTrack(oet, t);
                oet.addTrack(track);
            }
            track.addEvent(e);
            etd.increaseCount();
        }
        this.m_lastTimeStampParser = timeStampParser;
    }

    private void fixJavaThreadPool() {
        ConstantPool cp = this.m_environment.getConstantPool(8);
        if (cp != null) {
            cp.getConstantMap().getEntries();
        }
    }

    private Integer getTrackIdentifier(FLRThread t) {
        if (t != null) {
            return t.getTrackIdentifier();
        }
        return -1;
    }

    public Range getRange() {
        return new Range(this.m_startTime, this.m_endTime);
    }
}

