/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Reference;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.factories.StackTraceFactory;

public class FrameArrayParser
implements IParser {
    private final IParser m_parser;
    private Environment m_environment;
    private StackTraceFactory m_traceFactory;
    private FactoryState m_factoryState = FactoryState.UNINITIALIZED;

    FrameArrayParser(IParser parser, Environment environment) {
        this.m_parser = parser;
        this.m_environment = environment;
    }

    public int getSize() {
        return this.m_parser.getSize();
    }

    public Object read(byte[] data, int offset) {
        if (this.m_factoryState == FactoryState.VALID) {
            return this.m_traceFactory.createObject(-1L, this.resolve(this.m_parser.read(data, offset)));
        }
        if (this.m_factoryState == FactoryState.UNINITIALIZED) {
            this.m_traceFactory = (StackTraceFactory)this.m_environment.getFactory("StackTrace");
            this.m_factoryState = this.m_traceFactory == null ? FactoryState.INVALID : FactoryState.VALID;
            return this.read(data, offset);
        }
        return null;
    }

    Object resolve(Object o) {
        if (o instanceof Reference) {
            return this.resolve(((Reference)o).resolve());
        }
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            int n = 0;
            while (n < array.length) {
                array[n] = this.resolve(array[n]);
                ++n;
            }
            return array;
        }
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FactoryState {
        UNINITIALIZED,
        VALID,
        INVALID;

    }
}

