/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;

final class FactorParser
implements IParser {
    private final IParser m_parser;
    private final Number m_factor;

    FactorParser(IParser parser, Number factor) {
        this.m_parser = parser;
        this.m_factor = factor;
    }

    public int getSize() {
        return this.m_parser.getSize();
    }

    public Object read(byte[] data, int offset) {
        Object o = this.m_parser.read(data, offset);
        if (o != null) {
            return this.multiply(o);
        }
        return null;
    }

    private Object multiply(Object o) {
        if (o instanceof Integer) {
            return (Integer)o * this.m_factor.intValue();
        }
        if (o instanceof Long) {
            return (Long)o * this.m_factor.longValue();
        }
        if (o instanceof Short) {
            return (short)((Short)o * this.m_factor.shortValue());
        }
        if (o instanceof Double) {
            return (Double)o * this.m_factor.doubleValue();
        }
        if (o instanceof Float) {
            return Float.valueOf(((Float)o).floatValue() * this.m_factor.floatValue());
        }
        return null;
    }
}

