/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ByteParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ShortParser;

public final class ConstantPoolKeyParser
implements IParser {
    private final DataType m_dataType;
    private final int m_size;

    public ConstantPoolKeyParser(DataType dataType) {
        this.m_dataType = dataType;
        this.m_size = dataType.getSize();
    }

    public int getSize() {
        return this.m_size;
    }

    public long readKey(byte[] data, int offset) {
        switch (this.m_dataType) {
            case BYTE: 
            case U1: {
                return ByteParser.readByte(data, offset);
            }
            case SHORT: 
            case U2: {
                return ShortParser.readShort(data, offset);
            }
            case INTEGER: 
            case U4: 
            case FLOAT: {
                return IntegerParser.readInt(data, offset);
            }
            case LONG: 
            case U8: 
            case DOUBLE: {
                return LongParser.readLong(data, offset);
            }
        }
        throw new IllegalStateException("Not a valid data type for the constant pool. Must be numeric");
    }

    public Object read(byte[] data, int offset) {
        return this.readKey(data, offset);
    }
}

