/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.DataTypeParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.UTFStringParser;

final class ConstantPoolDescriptorParser
implements IParser {
    private final UTFStringParser NAME_PARSER = new UTFStringParser();
    private final UTFStringParser DESCRIPTION_PARSER = new UTFStringParser();
    private final DataTypeParser DATA_TYPE = new DataTypeParser();
    private int m_size;

    ConstantPoolDescriptorParser() {
    }

    public int getSize() {
        return this.m_size;
    }

    public Object read(byte[] data, int offset) {
        int index = offset;
        int constantPoolIndex = IntegerParser.readInt(data, index);
        String name = this.NAME_PARSER.read(data, index += 4);
        String description = this.DESCRIPTION_PARSER.read(data, index += this.NAME_PARSER.getSize());
        DataType dataType = this.DATA_TYPE.read(data, index += this.DESCRIPTION_PARSER.getSize());
        int structIndex = IntegerParser.readInt(data, index += this.DATA_TYPE.getSize());
        this.m_size = (index += 4) - offset;
        ConstantPool constantPool = new ConstantPool();
        constantPool.setName(name);
        constantPool.setDescription(description);
        constantPool.setDataType(dataType);
        constantPool.setPoolIndex(constantPoolIndex);
        constantPool.setStructIndex(structIndex);
        return constantPool;
    }
}

