/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Environment;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.PositionalLongMap;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ConstantPoolKeyParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;

final class ConstantMapParser
implements IParser {
    private final Environment m_environment;
    private int m_size;

    ConstantMapParser(Environment environment) {
        this.m_environment = environment;
    }

    public int getSize() {
        return this.m_size;
    }

    public ConstantPool read(byte[] data, int offset) {
        int index = offset;
        int poolIndex = IntegerParser.readInt(data, index);
        int entries = IntegerParser.readInt(data, index += 4);
        index += 4;
        ConstantPool cpd = this.m_environment.getConstantPool(poolIndex);
        ConstantPoolKeyParser keyParser = cpd.getKeyParser();
        IParser valueParser = cpd.getValueParser();
        PositionalLongMap constantMap = cpd.getConstantMap();
        int n = 0;
        while (n < entries) {
            constantMap.setPosition(this.m_environment.getCheckPointIndex());
            long key = keyParser.readKey(data, index);
            Object object = valueParser.read(data, index += keyParser.getSize());
            index += valueParser.getSize();
            constantMap.add(key, object);
            ++n;
        }
        this.m_size = index - offset;
        return cpd;
    }
}

