/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.EventTypeRetriever;
import com.jrockit.mc.flightrecorder.api.ProducerRetriever;
import com.jrockit.mc.flightrecorder.api.Retriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.IndexedValueRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.AllocatedByAllThreadsExtension;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.HeapFragmentationExtension;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.TopFrameClassRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.TopFrameMethodRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.TopFramePackageRetriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.synthetic.TopFrameRetriever;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RetrieverFactory {
    private RetrieverFactory() {
        throw new Error("Don't instantiate");
    }

    private static boolean isStackTrace(ValueDescriptor desc) {
        return "_stacktrace".equals(desc.getIdentifier()) || "stacktrace".equals(desc.getIdentifier());
    }

    public static IRetriever createDurationRetriverRetriever(EventTypeDescriptor eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("Duration");
        b.setContentType(UnitLookup.TIMESPAN.getIdentifier());
        b.setDescription("The time the event took");
        b.setIdentifier("(duration)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESPAN.getIdentifier());
        return new DurationRetriver(b, eventType.getPath());
    }

    public static IRetriever createStartTimeRetriever(EventTypeDescriptor eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("Start Time");
        b.setDescription("The start time of the event");
        b.setIdentifier("(startTime)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESTAMP.getIdentifier());
        return new StartTimeRetriever(b, eventType.getPath());
    }

    public static IRetriever createEndTimeRetriever(EventTypeDescriptor eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("End Time");
        b.setDescription("The end time of the event, when it was committed");
        b.setIdentifier("(endTime)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESTAMP.getIdentifier());
        return new EndTimeRetriver(b, eventType.getPath());
    }

    public static List<IRetriever> createRetrivers(EventTypeDescriptor descriptor, IEventType et) {
        ArrayList<IRetriever> retrievers = new ArrayList<IRetriever>();
        retrievers.add(RetrieverFactory.createStartTimeRetriever(descriptor));
        retrievers.add(RetrieverFactory.createEndTimeRetriever(descriptor));
        retrievers.add(RetrieverFactory.createDurationRetriverRetriever(descriptor));
        retrievers.addAll(RetrieverFactory.add(0, descriptor.getPath(), "", "", descriptor.getValueDescriptors()));
        retrievers.add(new EventTypeRetriever(et));
        retrievers.add(new ProducerRetriever(et));
        return retrievers;
    }

    private static List<IRetriever> add(int index, String path, String namePreifx, String identifierPrecix, ValueDescriptor[] descs) {
        ArrayList<IRetriever> retrievers = new ArrayList<IRetriever>();
        ValueDescriptor[] valueDescriptorArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier;
            ValueDescriptor desc = valueDescriptorArray[n2];
            String name = namePreifx.length() > 0 ? String.valueOf(namePreifx) + " : " + desc.getName() : desc.getName();
            String string = identifier = identifierPrecix.length() > 0 ? String.valueOf(identifierPrecix) + ":" + desc.getIdentifier() : desc.getIdentifier();
            if (desc.getDataType() == DataType.STRUCT) {
                ValueDescriptor[] valueDescChildren = desc.getChildren();
                List<IRetriever> children = valueDescChildren.length == 1 ? RetrieverFactory.add(index, path, namePreifx, identifierPrecix, valueDescChildren) : RetrieverFactory.add(index, path, name, identifier, valueDescChildren);
                retrievers.addAll(children);
                index += children.size();
            } else {
                retrievers.add(new IndexedValueRetriever(desc, name, identifier, path, index));
                if (RetrieverFactory.isStackTrace(desc)) {
                    retrievers.add(new TopFrameRetriever(path, identifier, index));
                    retrievers.add(new TopFramePackageRetriever(path, identifier, index));
                    retrievers.add(new TopFrameClassRetriever(path, identifier, index));
                    retrievers.add(new TopFrameMethodRetriever(path, identifier, index));
                }
                ++index;
            }
            ++n2;
        }
        return retrievers;
    }

    public static void addCustom(IEventType type) {
        HeapFragmentationExtension.extend(type);
        AllocatedByAllThreadsExtension.extend(type);
    }

    private static final class DurationRetriver
    extends Retriever {
        private DurationRetriver(ValueDescriptor d, String path) {
            super(d, path);
        }

        public Object getValue(IEvent event) {
            return event.getDuration();
        }
    }

    private static final class EndTimeRetriver
    extends Retriever {
        private EndTimeRetriver(ValueDescriptor d, String path) {
            super(d, path);
        }

        public Object getValue(IEvent event) {
            return event.getEndTimestamp();
        }
    }

    private static final class StartTimeRetriever
    extends Retriever {
        private StartTimeRetriever(ValueDescriptor d, String path) {
            super(d, path);
        }

        public Object getValue(IEvent event) {
            return event.getStartTimestamp();
        }
    }
}

