/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.Reference;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;
import java.util.ArrayList;

public final class PositionalMapEntry {
    private final ArrayList<Object> m_objects = new ArrayList(3);
    private final ArrayList<Integer> m_positions = new ArrayList(3);
    private final IPoolFactory m_factory;
    private final long m_key;
    private Object m_currentObject = null;
    private int m_nextPosition = -1;
    private int m_index = 0;

    PositionalMapEntry(IPoolFactory factory, long key) {
        this.m_factory = factory;
        this.m_key = key;
    }

    void add(int position, Object o) {
        this.m_objects.add(o);
        this.m_positions.add(position);
    }

    public Object get(int position) {
        if (position > this.m_nextPosition) {
            this.moveToNext(position);
        }
        return this.m_currentObject;
    }

    Object resolve(Object o) {
        if (o instanceof Reference) {
            return this.resolve(((Reference)o).resolve());
        }
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            int n = 0;
            while (n < array.length) {
                array[n] = this.resolve(array[n]);
                ++n;
            }
            return array;
        }
        return o;
    }

    private void setCurrentObject(Object o) {
        Object resolved = this.resolve(o);
        this.m_currentObject = this.m_factory == null ? resolved : this.m_factory.createObject(this.m_key, resolved);
    }

    private void moveToNext(int position) {
        while (this.m_index < this.m_positions.size()) {
            this.m_nextPosition = this.m_positions.get(this.m_index);
            ++this.m_index;
            if (position > this.m_nextPosition) continue;
            this.setCurrentObject(this.m_objects.get(this.m_index - 1));
            return;
        }
        this.m_nextPosition = Integer.MAX_VALUE;
    }

    private String formatObject(Object o) {
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            StringBuilder s = new StringBuilder();
            s.append("{");
            int n = 0;
            while (n < os.length) {
                s.append(this.formatObject(os[n]));
                if (n < os.length - 1) {
                    s.append(", ");
                }
                ++n;
            }
            s.append("}");
            return s.toString();
        }
        return String.valueOf(o);
    }

    public String toString() {
        if (this.m_objects.size() == 1) {
            return this.formatObject(this.m_currentObject);
        }
        String toString = "-" + this.m_positions.get(0) + " = " + this.formatObject(this.m_currentObject) + ", ";
        int n = 1;
        while (n < this.m_objects.size() - 1) {
            toString = String.valueOf(toString) + this.m_positions.get(n - 1) + "-" + this.m_positions.get(n) + "=" + this.m_objects.get(n) + "\n";
            ++n;
        }
        toString = String.valueOf(toString) + this.m_positions.get(this.m_objects.size() - 1) + "- = " + this.formatObject(this.m_objects.get(this.m_objects.size() - 1));
        return toString;
    }
}

