/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.PositionalMapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PositionalLongMap {
    private final HashMap<PositionKey, PositionalMapEntry> m_lookupMap = new HashMap(17, 0.5f);
    private final PositionKey m_lookupKey = new PositionKey(-1L);
    private int m_currentIndex;
    private int m_lastAddedIndex;
    private final ConstantPool m_pool;

    public PositionalLongMap(ConstantPool p) {
        this.m_pool = p;
    }

    public void add(long identifier, Object object) {
        if (this.m_currentIndex < this.m_lastAddedIndex) {
            throw new IllegalArgumentException("You must add values in a positional increasing order");
        }
        PositionalMapEntry lookup = this.getLookup(identifier);
        if (lookup == null) {
            lookup = new PositionalMapEntry(this.m_pool.getFactory(), identifier);
            this.m_lookupMap.put(new PositionKey(identifier), lookup);
        }
        this.m_lastAddedIndex = this.m_currentIndex;
        lookup.add(this.m_currentIndex, object);
    }

    private PositionalMapEntry getLookup(long identifier) {
        this.m_lookupKey.identifier = identifier;
        return this.m_lookupMap.get(this.m_lookupKey);
    }

    public Object get(long identifier) {
        PositionalMapEntry lookup = this.getLookup(identifier);
        if (lookup != null) {
            return lookup.get(this.m_currentIndex);
        }
        return null;
    }

    public void setPosition(int index) {
        this.m_currentIndex = index;
        this.m_lastAddedIndex = 0;
    }

    Collection<PositionKey> getKeys() {
        return this.m_lookupMap.keySet();
    }

    PositionalMapEntry getEntry(PositionKey key) {
        return this.m_lookupMap.get(key);
    }

    public List<Object> getEntries() {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (PositionalMapEntry pme : this.m_lookupMap.values()) {
            Object o = pme.get(this.m_currentIndex);
            entries.add(o);
        }
        return entries;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        for (PositionKey key : this.getKeys()) {
            PositionalMapEntry o = this.getLookup(key.identifier);
            toString.append(key);
            toString.append("\t{");
            toString.append(this.formatObject(o));
            toString.append("}\n");
        }
        return toString.toString();
    }

    private String formatObject(Object o) {
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            String s = "{ ";
            int n = 0;
            while (n < os.length) {
                s = String.valueOf(s) + this.formatObject(os[n]);
                if (n < os.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++n;
            }
            s = String.valueOf(s) + "}";
            return s;
        }
        return String.valueOf(o);
    }

    public void clear() {
        this.m_lookupMap.clear();
    }

    public static final class PositionKey {
        public long identifier;

        PositionKey(long identifier) {
            this.identifier = identifier;
        }

        public int hashCode() {
            return (int)(this.identifier ^ this.identifier >>> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof PositionKey) {
                return ((PositionKey)object).identifier == this.identifier;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.identifier);
        }
    }
}

