/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.api.PathDescriptorRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrack;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.RetrieverFactory;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedEventType
implements IEventType {
    private String m_path = "";
    private String m_description = "";
    private Integer m_identifier;
    private String m_name = "";
    private Object m_userData;
    private int m_eventCount;
    private Map<String, IRetriever> m_retrivers = new LinkedHashMap<String, IRetriever>();
    private IProducer m_producer;
    private ArrayList<ITrack> m_tracks = new ArrayList();
    private Color m_color;
    private int m_bitField;

    public static OptimizedEventType create(IProducer producer, EventTypeDescriptor etd) {
        OptimizedEventType oe = new OptimizedEventType();
        oe.setIdentifier(etd.getIdentifier());
        oe.setDescription(etd.getDescription());
        oe.setName(etd.getName());
        oe.setPath(etd.getPath());
        oe.setProducer(producer);
        for (IRetriever r : RetrieverFactory.createRetrivers(etd, oe)) {
            oe.addRetriever(r);
        }
        return oe;
    }

    @Override
    public void addRetriever(IRetriever newRetriever) {
        this.m_retrivers.put(newRetriever.getAttributeIdentifier(), newRetriever);
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public int getEventCount() {
        return this.m_eventCount;
    }

    @Override
    public Integer getId() {
        return this.m_identifier;
    }

    public void setIdentifier(int identifier) {
        this.m_identifier = identifier;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public IProducer getProducer() {
        return this.m_producer;
    }

    public void setProducer(IProducer producer) {
        this.m_producer = producer;
    }

    @Override
    public IRetriever getRetriever(String identifier) {
        return this.m_retrivers.get(identifier);
    }

    @Override
    public Map<String, IRetriever> getRetrivers() {
        return this.m_retrivers;
    }

    @Override
    public int getTransitionFromIndex() {
        return 0;
    }

    @Override
    public String getTransitionFromName() {
        return null;
    }

    @Override
    public String getTransitionToName() {
        return null;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object object) {
        this.m_userData = object;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setPath(String path) {
        this.m_path = path;
        PathDescriptor pd = PathDescriptorRepository.getDefault().createPathDescriptor(path, this.getName());
        this.m_color = pd.getColor();
        this.m_name = pd.getName();
    }

    public void addTrack(JRockitTrack track) {
        this.m_tracks.add(track);
    }

    @Override
    public List<ITrack> getTracks() {
        return this.m_tracks;
    }

    @Override
    public int getBitField() {
        return this.m_bitField;
    }

    @Override
    public void setBitField(int i) {
        this.m_bitField = i;
    }
}

