/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupTable<T> {
    private final double m_loadFactor;
    private Entry<T>[] m_table;
    private int m_size;
    private int m_threshold;

    public LookupTable(int initialCapacity, double loadFactor) {
        this.m_loadFactor = loadFactor;
        this.m_table = this.createTable(initialCapacity);
    }

    private Entry<T>[] createTable(int size) {
        this.m_threshold = (int)((double)size * this.m_loadFactor);
        return new Entry[size];
    }

    public void put(long key, T value) {
        if (this.get(key) == null) {
            if (this.m_size >= this.m_threshold) {
                this.resize();
                this.put(key, value);
            } else {
                int index = this.calculateIndex(key);
                Entry<T> e = new Entry<T>(key, value, this.m_table[index]);
                this.m_table[index] = e;
                ++this.m_size;
            }
        }
    }

    private int calculateIndex(long key) {
        return (int)key % this.m_table.length;
    }

    public T get(long key) {
        Entry entry = this.m_table[this.calculateIndex(key)];
        while (entry != null) {
            if (entry.key == key) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void resize() {
        Entry<T>[] oldTable = this.m_table;
        this.m_table = this.createTable(2 * this.m_table.length + 1);
        int n = 0;
        while (n < oldTable.length) {
            Entry entry = oldTable[n];
            while (entry != null) {
                Entry current = entry;
                entry = entry.next;
                int index = this.calculateIndex(current.key);
                current.next = (Entry)this.m_table[index];
                this.m_table[index] = current;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        Entry<T>[] entryArray = this.m_table;
        int n = this.m_table.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                toString.append(entry.key);
                toString.append("=");
                toString.append(entry.value);
                toString.append("\n");
                entry = entry.next;
            }
            ++n2;
        }
        return toString.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<T> {
        private final long key;
        private final T value;
        private Entry<T> next;

        public Entry(long key, T value, Entry<T> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

