/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.ITrackDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRockitTrackDescriptor
implements ITrackDescriptor {
    private final Map<Object, ITrackDescriptor> m_children = new HashMap<Object, ITrackDescriptor>();
    private final Map<String, Object> m_properties = new HashMap<String, Object>();
    private final String m_name;
    private final String m_type;
    private final String m_id;
    private volatile IRange m_range;

    public JRockitTrackDescriptor(String id, String name, IRange range, String type) {
        this.m_id = id;
        this.m_name = name;
        this.m_type = type;
        this.m_range = range;
    }

    public void add(JRockitTrackDescriptor descriptor) {
        this.m_children.put(descriptor.getIdentifier(), descriptor);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public ITrackDescriptor getChild(String name) {
        return this.m_children.get(name);
    }

    @Override
    public Collection<ITrackDescriptor> getChildren() {
        return this.m_children.values();
    }

    @Override
    public Collection<ITrackDescriptor> getAllChildren() {
        ArrayList<ITrackDescriptor> allChildren = new ArrayList<ITrackDescriptor>();
        for (ITrackDescriptor d : this.getChildren()) {
            allChildren.add(d);
            allChildren.addAll(d.getAllChildren());
        }
        return allChildren;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public IRange getRange() {
        return this.m_range;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public String getIdentifier() {
        return this.m_id;
    }

    public void setStartTime(long startTime) {
        this.m_range = new Range(startTime, this.m_range.getEndTimestamp());
    }

    public void setEndTime(long endTimestamp) {
        this.m_range = new Range(this.m_range.getStartTimestamp(), endTimestamp);
    }

    public String toString() {
        return this.m_name;
    }
}

