/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.RangeIterator;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BrokenIterator;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrack;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitTrackDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.OptimizedEventType;
import com.jrockit.mc.flightrecorder.internal.api.factories.FLRThread;
import com.jrockit.mc.flightrecorder.internal.api.range.IPriorityProvider;
import com.jrockit.mc.flightrecorder.internal.api.range.PriorityIterator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackDescriptor;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRockitGlobalRepository
implements ITrackRepository {
    private final Map<JRockitTrackDescriptor, JRockitTrack> m_trackbyDescriptor = new HashMap<JRockitTrackDescriptor, JRockitTrack>();
    private final Map<TrackKey, JRockitTrack> m_tracks = new HashMap<TrackKey, JRockitTrack>();
    private final JRockitTrackDescriptor m_root = new JRockitTrackDescriptor("root", null, null, null);
    private final Collection<Object> m_holders = new ArrayList<Object>();
    private JRockitTrackDescriptor m_threadGroup;
    private final TrackKey m_lookupKey = new TrackKey();
    private final List<IEvent> m_broken = new ArrayList<IEvent>();

    public JRockitGlobalRepository() {
        this.m_threadGroup = new JRockitTrackDescriptor("fakedGroup", "Faked Group", Range.INFINITE_RANGE, "threadGroup");
        this.m_root.add(this.m_threadGroup);
    }

    @Override
    public final ITrack getTrack(ITrackDescriptor descriptor) {
        return this.m_trackbyDescriptor.get(descriptor);
    }

    @Override
    public Collection<ITrackDescriptor> getTrackDescriptors() {
        return this.m_root.getChildren();
    }

    public JRockitTrack getTrack(OptimizedEventType type) {
        JRockitTrack track = this.lookupTrack(type.getId(), -1);
        if (track == null) {
            track = this.addTrack(type, null);
            type.addTrack(track);
        }
        return track;
    }

    public JRockitTrack addTrack(IEventType eventType, FLRThread t) {
        JRockitTrackDescriptor threadTrack = this.getThreadTrack(t);
        TrackKey trackKey = new TrackKey();
        trackKey.trackIdentifier = this.extractThreadId(t);
        trackKey.eventTypeIdentifier = eventType.getId();
        JRockitTrack eventTypeTrack = this.getEventTypeTrack(threadTrack, eventType);
        this.m_tracks.put(trackKey, eventTypeTrack);
        return eventTypeTrack;
    }

    private Integer extractThreadId(FLRThread t) {
        if (t != null) {
            return t.getTrackIdentifier();
        }
        return -1;
    }

    private JRockitTrack getEventTypeTrack(JRockitTrackDescriptor parentTrack, IEventType eventType) {
        JRockitTrack track;
        String path = eventType.getPath();
        JRockitTrackDescriptor desc = (JRockitTrackDescriptor)parentTrack.getChild(path);
        if (desc == null) {
            desc = new JRockitTrackDescriptor(eventType.getPath(), "Track for " + path, IRange.INFINITE_RANGE, "eventType");
            desc.getProperties().put("color", eventType.getColor());
            parentTrack.add(desc);
        }
        if ((track = this.m_trackbyDescriptor.get(desc)) == null) {
            track = new JRockitTrack(String.valueOf(parentTrack.getIdentifier()) + " " + desc.getIdentifier(), desc, this);
            this.m_trackbyDescriptor.put(desc, track);
            this.m_holders.add(track.getRangeHolder());
        }
        return track;
    }

    public JRockitTrackDescriptor getThreadTrack(FLRThread t) {
        JRockitTrackDescriptor desc;
        if (t == null) {
            desc = (JRockitTrackDescriptor)this.m_root.getChild("global");
            if (desc == null) {
                desc = new JRockitTrackDescriptor("global", "Global", IRange.INFINITE_RANGE, "global");
                this.m_root.add(desc);
            }
        } else {
            desc = (JRockitTrackDescriptor)this.m_root.getChild(this.createJavaThreadId(t));
            if (desc == null) {
                desc = new JRockitTrackDescriptor(this.createJavaThreadId(t), t.getThreadName(), IRange.INFINITE_RANGE, "platformId");
                desc.getProperties().put("thread", t);
                this.m_root.add(desc);
            }
        }
        return desc;
    }

    private String createJavaThreadId(FLRThread t) {
        return "" + t.getTrackIdentifier();
    }

    protected List<String> split(String path) {
        ArrayList<String> tokenLIst = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreElements()) {
            tokenLIst.add((String)st.nextElement());
        }
        tokenLIst.remove(tokenLIst.size() - 1);
        return tokenLIst;
    }

    public JRockitTrack lookupTrack(int eventTypeIdentifier, int trackIdentifier) {
        this.m_lookupKey.eventTypeIdentifier = eventTypeIdentifier;
        this.m_lookupKey.trackIdentifier = trackIdentifier;
        return this.m_tracks.get(this.m_lookupKey);
    }

    public Iterator createIterator(IRange range) {
        return new RangeIterator(this.m_holders, range, IRangeHolder.ALWAYS_TRUE_FILTER, RangeSelection.NORMAL);
    }

    @Override
    public Collection<ITrackDescriptor> getAllTrackDescriptors() {
        return this.m_root.getAllChildren();
    }

    public List<ITrack> getTrack(String suffix) {
        ArrayList<ITrack> tracks = new ArrayList<ITrack>();
        for (ITrackDescriptor trackDescriptor : this.getTrackDescriptors(suffix)) {
            ITrack t = this.getTrack(trackDescriptor);
            if (t == null) continue;
            tracks.add(t);
        }
        return tracks;
    }

    public List<ITrackDescriptor> getTrackDescriptors(String suffix) {
        ArrayList<ITrackDescriptor> desc = new ArrayList<ITrackDescriptor>();
        for (ITrackDescriptor descriptor : this.getAllTrackDescriptors()) {
            if (!suffix.equals(descriptor.getIdentifier())) continue;
            desc.add(descriptor);
        }
        return desc;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (ITrackDescriptor td : this.getAllTrackDescriptors()) {
            s.append(td.getName());
            s.append(" (");
            s.append(td.getIdentifier());
            s.append(")\n");
        }
        return s.toString();
    }

    @Override
    public Iterator<IEvent> inOrderIteror() {
        Collection<JRockitTrack> c = this.m_tracks.values();
        Iterator[] iterators = new Iterator[c.size()];
        int index = 0;
        Iterator<JRockitTrack> iterator = c.iterator();
        while (iterator.hasNext()) {
            JRockitTrack t;
            JRockitTrack j = t = iterator.next();
            iterators[index] = j.iterator();
            ++index;
        }
        return new PriorityIterator(iterators, IPriorityProvider.ORDER_BY_START_TIME);
    }

    public void addBroken(IEvent event) {
        this.m_broken.add(event);
    }

    @Override
    public Iterator<IEvent> brokenIterator(IRange range) {
        return new BrokenIterator(this.m_broken, range);
    }

    public static class TrackKey {
        public int trackIdentifier;
        public int eventTypeIdentifier;

        public int hashCode() {
            return 31 * this.eventTypeIdentifier + this.trackIdentifier;
        }

        public boolean equals(Object object) {
            if (object instanceof TrackKey) {
                TrackKey that = (TrackKey)object;
                return this.eventTypeIdentifier == that.eventTypeIdentifier && this.trackIdentifier == that.trackIdentifier;
            }
            return false;
        }
    }
}

