/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.api.Producer;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.TimeLocale;
import com.jrockit.mc.flightrecorder.internal.api.factories.FactoryRepository;
import com.jrockit.mc.flightrecorder.internal.api.factories.IPoolFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Environment {
    private final LinkedHashMap<Integer, ConstantPool> m_constantPools = new LinkedHashMap();
    private int m_checkPoint;
    private final Key m_lookupKey;
    private final HashMap<Key, EventTypeDescriptor> m_eventTypeDescriptors = new HashMap();
    private TimeLocale m_timeLocale;
    private final FactoryRepository m_factoryRepository;
    private LinkedHashMap<Integer, Producer> m_producers = new LinkedHashMap();

    public Environment() {
        this.m_lookupKey = new Key(0);
        this.addDefaults();
        this.m_factoryRepository = new FactoryRepository();
    }

    void addDefaults() {
        EventTypeDescriptor meta = new EventTypeDescriptor(0);
        meta.setAccept(false);
        EventTypeDescriptor checkPoint = new EventTypeDescriptor(1);
        checkPoint.setAccept(false);
        this.m_eventTypeDescriptors.put(new Key(0), meta);
        this.m_eventTypeDescriptors.put(new Key(1), checkPoint);
    }

    public EventTypeDescriptor addEventTypeDescriptor(EventTypeDescriptor newEtd) {
        this.m_lookupKey.id = newEtd.getIdentifier();
        EventTypeDescriptor etd = this.m_eventTypeDescriptors.get(this.m_lookupKey);
        if (etd == null) {
            this.m_eventTypeDescriptors.put(new Key(newEtd.getIdentifier()), newEtd);
            etd = newEtd;
        }
        return etd;
    }

    public IPoolFactory getFactory(ConstantPool pool) {
        return this.m_factoryRepository.getFactory(pool);
    }

    public EventTypeDescriptor getEventTypeDescriptor(int eventTypeid) {
        this.m_lookupKey.id = eventTypeid;
        EventTypeDescriptor etd = this.m_eventTypeDescriptors.get(this.m_lookupKey);
        if (etd != null) {
            return etd;
        }
        EventTypeDescriptor desc = this.createEventTypeDescriptor(eventTypeid);
        this.m_eventTypeDescriptors.put(new Key(eventTypeid), desc);
        return desc;
    }

    private EventTypeDescriptor createEventTypeDescriptor(int eventTypeid) {
        return new EventTypeDescriptor(eventTypeid);
    }

    public Collection<EventTypeDescriptor> getEventTypeDescriptors() {
        return this.m_eventTypeDescriptors.values();
    }

    public ConstantPool getConstantPool(int index) {
        return this.m_constantPools.get(index);
    }

    public void clearConstantPools() {
        for (ConstantPool pool : this.m_constantPools.values()) {
            pool.clear();
        }
    }

    public void nextCheckPoint() {
        ++this.m_checkPoint;
        this.setCheckPoint(this.m_checkPoint);
    }

    public void resetCheckPoint() {
        this.setCheckPoint(0);
    }

    public void setCheckPoint(int index) {
        for (ConstantPool pool : this.m_constantPools.values()) {
            pool.getConstantMap().setPosition(index);
        }
        this.m_checkPoint = index;
    }

    public int getCheckPointIndex() {
        return this.m_checkPoint;
    }

    public void addConstantPool(ConstantPool pool) {
        ConstantPool oldPool = this.m_constantPools.get(pool.getPoolIndex());
        if (oldPool != null) {
            oldPool.clear();
        } else {
            this.m_constantPools.put(pool.getPoolIndex(), pool);
        }
    }

    public Collection<ConstantPool> getConstantPools() {
        return this.m_constantPools.values();
    }

    public void setTimeLocale(TimeLocale ti) {
        this.m_timeLocale = ti;
    }

    public TimeLocale getTimeLocale() {
        return this.m_timeLocale;
    }

    public Producer getProducer(int pid) {
        Producer producer = this.m_producers.get(pid);
        if (producer == null) {
            producer = new Producer(pid);
            this.m_producers.put(pid, producer);
        }
        return producer;
    }

    public EventTypeDescriptor findFirstEventTypeDescriptor(String typePath) {
        for (EventTypeDescriptor descriptor : this.getEventTypeDescriptors()) {
            if (!typePath.equals(descriptor.getPath())) continue;
            return descriptor;
        }
        return null;
    }

    public IPoolFactory getFactory(String name) {
        return this.m_factoryRepository.getFactory(name);
    }

    private static final class Key {
        public int id;

        public Key(int id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object key) {
            if (key instanceof Key) {
                return ((Key)key).id == this.id;
            }
            return false;
        }
    }
}

