/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.SortedInput;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChunkDescriptor {
    private static final byte[] FLIGHT_RECORDER_MAGIC;
    private final int m_major;
    private final int m_minor;
    private final long m_metadataOffset;
    private final byte[] m_magic;
    private int[] m_indices;
    private ArrayList<SortedInput.EventPosition> m_eventPositions;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 70;
        byArray[1] = 76;
        byArray[2] = 82;
        FLIGHT_RECORDER_MAGIC = byArray;
    }

    public ChunkDescriptor(int major, int minor, long metadataOffset, byte[] magic) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_metadataOffset = metadataOffset;
        this.m_magic = magic;
    }

    public boolean hasFlightRecorderMagic() {
        int n = 0;
        while (n < FLIGHT_RECORDER_MAGIC.length) {
            if (FLIGHT_RECORDER_MAGIC[n] != this.m_magic[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasReasonableMetadataOffset() {
        return this.m_metadataOffset < 0x3FFFFFFFL;
    }

    public String getMagicString() {
        return Arrays.toString(this.m_magic);
    }

    public int getMajorVersion() {
        return this.m_major;
    }

    public int getMinorVersion() {
        return this.m_minor;
    }

    public long getMetadataOffset() {
        return this.m_metadataOffset;
    }

    public String toString() {
        String toString = "";
        toString = String.valueOf(toString) + "Magic: " + this.getMagicString() + ", ";
        toString = String.valueOf(toString) + "Version: " + this.getMajorVersion() + "." + this.getMinorVersion() + ", ";
        toString = String.valueOf(toString) + "Metadata Offset: " + this.getMetadataOffset();
        return toString;
    }

    int[] getEventIndices() {
        return this.m_indices;
    }

    public void setPositions(ArrayList<SortedInput.EventPosition> positions) {
        this.m_eventPositions = positions;
    }

    public ArrayList<SortedInput.EventPosition> getPositions() {
        return this.m_eventPositions;
    }
}

